/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.IContainer;
import org.jacorb.notification.filter.AbstractFilter;
import org.jacorb.notification.filter.IFilterFactoryDelegate;
import org.jacorb.notification.filter.MappingFilterImpl;
import org.jacorb.notification.filter.etcl.ETCLFilter;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.util.LogUtil;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CosNotifyFilter.InvalidGrammar;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.defaults.ComponentAdapterFactory;
import org.picocontainer.defaults.ConstructorInjectionComponentAdapterFactory;

public class DefaultFilterFactoryDelegate
implements IFilterFactoryDelegate,
Disposable {
    private final List availableFilters_ = new ArrayList();
    private final MutablePicoContainer filterPico_;
    private final ORB orb_;
    private final Logger logger_;
    private final IContainer container_;
    private final ComponentAdapterFactory componentAdapterFactory_;

    public DefaultFilterFactoryDelegate(IContainer iContainer, Configuration configuration, ComponentAdapterFactory componentAdapterFactory) {
        MutablePicoContainer mutablePicoContainer;
        this.componentAdapterFactory_ = componentAdapterFactory;
        this.container_ = iContainer;
        this.filterPico_ = mutablePicoContainer = iContainer.getContainer();
        this.orb_ = (ORB)mutablePicoContainer.getComponentInstanceOfType(ORB.class);
        this.logger_ = LogUtil.getLogger(configuration, this.getClass().getName());
        this.loadFilterPlugins(configuration);
    }

    public DefaultFilterFactoryDelegate(IContainer iContainer, Configuration configuration) {
        this(iContainer, configuration, (ComponentAdapterFactory)new ConstructorInjectionComponentAdapterFactory());
    }

    public void dispose() {
        this.container_.destroy();
    }

    private void loadFilterPlugins(Configuration configuration) {
        ComponentAdapter componentAdapter = this.componentAdapterFactory_.createComponentAdapter((Object)"EXTENDED_TCL", ETCLFilter.class, null);
        this.filterPico_.registerComponent(componentAdapter);
        this.availableFilters_.add("EXTENDED_TCL");
        for (String string : DefaultFilterFactoryDelegate.getAttributeNamesWithPrefix(configuration, "jacorb.notification.filter.plugin")) {
            String string2 = null;
            try {
                String string3 = string.substring("jacorb.notification.filter.plugin".length() + 1);
                this.logger_.info("Loading Filterplugin for Grammar: " + string3);
                string2 = configuration.getAttribute(string);
                Class clazz = ObjectUtil.classForName(string2);
                ComponentAdapter componentAdapter2 = this.componentAdapterFactory_.createComponentAdapter((Object)string3, clazz, null);
                this.filterPico_.registerComponent(componentAdapter2);
                this.availableFilters_.add(string3);
            }
            catch (ConfigurationException configurationException) {
                this.logger_.error("Unable to access attribute: " + string, configurationException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.logger_.error("Property " + string + ": Unable to load FilterPlugin " + string2 + ". The FilterPlugin will not be available.", classNotFoundException);
            }
        }
    }

    private String getAvailableConstraintLanguages() {
        Iterator iterator = this.availableFilters_.iterator();
        StringBuffer stringBuffer = new StringBuffer((String)iterator.next());
        while (iterator.hasNext()) {
            stringBuffer.append(", ");
            stringBuffer.append(iterator.next());
        }
        return stringBuffer.toString();
    }

    public AbstractFilter create_filter_servant(String string) throws InvalidGrammar {
        AbstractFilter abstractFilter = (AbstractFilter)this.filterPico_.getComponentInstance((Object)string);
        if (abstractFilter == null) {
            this.logger_.error("unable to create FilterServant as grammar " + string + " is unknown");
            throw new InvalidGrammar("Constraint Language '" + string + "' is not supported. Supported are: " + this.getAvailableConstraintLanguages());
        }
        return abstractFilter;
    }

    public MappingFilterImpl create_mapping_filter_servant(Configuration configuration, String string, Any any) throws InvalidGrammar {
        AbstractFilter abstractFilter = this.create_filter_servant(string);
        return new MappingFilterImpl(this.orb_, configuration, abstractFilter, any);
    }

    static List getAttributeNamesWithPrefix(Configuration configuration, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = configuration.getAttributeNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith(string)) continue;
            arrayList.add(stringArray[i]);
        }
        return Collections.unmodifiableList(arrayList);
    }
}

