/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.DefaultProfileSelector;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ProfileSelector;
import org.jacorb.orb.factory.SocketFactory;
import org.jacorb.orb.factory.SocketFactoryManager;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.INTERNAL;
import org.omg.ETF.Factories;

public class TransportManager
implements Configurable {
    private SocketFactory socket_factory = null;
    private SocketFactory ssl_socket_factory = null;
    private ORB orb = null;
    private org.jacorb.config.Configuration configuration = null;
    private Logger logger = null;
    private List factoryClassNames = null;
    private ProfileSelector profileSelector = null;
    private SocketFactoryManager socketFactoryManager = null;
    private Map factoriesMap = null;
    private List factoriesList = null;

    public TransportManager(ORB oRB) {
        this.orb = oRB;
        this.socketFactoryManager = new SocketFactoryManager(oRB);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = (org.jacorb.config.Configuration)configuration;
        this.logger = this.configuration.getNamedLogger("jacorb.orb.giop");
        this.socketFactoryManager.configure(this.configuration);
        this.factoryClassNames = this.configuration.getAttributeList("jacorb.transport.factories");
        if (this.factoryClassNames.isEmpty()) {
            this.factoryClassNames.add("org.jacorb.orb.iiop.IIOPFactories");
        }
        this.profileSelector = (ProfileSelector)this.configuration.getAttributeAsObject("jacorb.transport.client.selector");
        if (this.profileSelector == null) {
            this.profileSelector = new DefaultProfileSelector();
        }
        if (this.configuration.getAttribute("jacorb.security.support_ssl", "off").equals("on")) {
            String string = this.configuration.getAttribute("jacorb.ssl.socket_factory", "");
            if (string.length() == 0) {
                throw new RuntimeException("SSL support is on, but the property \"jacorb.ssl.socket_factory\" is not set!");
            }
            try {
                Class clazz = ObjectUtil.classForName(string);
                Constructor constructor = clazz.getConstructor(ORB.class);
                this.ssl_socket_factory = (SocketFactory)constructor.newInstance(this.orb);
            }
            catch (Exception exception) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error(exception.getMessage());
                }
                throw new RuntimeException("SSL support is on, but the ssl socket factory can't be instantiated (" + exception.getMessage() + ")!");
            }
        }
        this.socket_factory = this.socketFactoryManager.getSocketFactory();
    }

    public ProfileSelector getProfileSelector() {
        return this.profileSelector;
    }

    public SocketFactoryManager getSocketFactoryManager() {
        return this.socketFactoryManager;
    }

    public SocketFactory getSocketFactory() {
        return this.socket_factory;
    }

    public SocketFactory getSSLSocketFactory() {
        return this.ssl_socket_factory;
    }

    public synchronized Factories getFactories(int n) {
        if (this.factoriesMap == null) {
            this.loadFactories();
        }
        return (Factories)this.factoriesMap.get(new Integer(n));
    }

    public synchronized List getFactoriesList() {
        if (this.factoriesList == null) {
            this.loadFactories();
        }
        return Collections.unmodifiableList(this.factoriesList);
    }

    private void loadFactories() {
        if (this.configuration == null) {
            throw new BAD_INV_ORDER("TransportManager not configured!");
        }
        if (this.factoryClassNames == null) {
            throw new INTERNAL("factoryClassNames should not be null");
        }
        this.factoriesMap = new HashMap();
        this.factoriesList = new ArrayList();
        for (String string : this.factoryClassNames) {
            Factories factories = this.instantiateFactories(string);
            this.factoriesMap.put(new Integer(factories.profile_tag()), factories);
            this.factoriesList.add(factories);
        }
    }

    private Factories instantiateFactories(String string) {
        try {
            Class clazz = ObjectUtil.classForName(string);
            Configurable configurable = (Configurable)clazz.newInstance();
            configurable.configure(this.configuration);
            return (Factories)((Object)configurable);
        }
        catch (Exception exception) {
            throw new RuntimeException("could not instantiate Factories class " + string + ", exception: " + exception);
        }
    }
}

