/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.LoggerModule;

import com.n2bb.LoggerModule.MessageQueue;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import org.apache.log4j.Logger;

public class UDPListener
extends Thread {
    private DatagramSocket dataSocket;
    private int packetLength = 2048;
    private MessageQueue mq;
    private Logger logger = Logger.getLogger(UDPListener.class);

    public UDPListener(int aPort, MessageQueue msgQ, int rcvBufferSize) throws Exception {
        this.logger.info((Object)("UDPListener starting - requested socket receive buffer size... " + rcvBufferSize));
        this.mq = msgQ;
        this.dataSocket = new DatagramSocket(aPort);
        this.dataSocket.setReceiveBufferSize(rcvBufferSize);
        this.logger.info((Object)("socket receive buffer size..." + this.dataSocket.getReceiveBufferSize()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.logger.info((Object)"UDPListener thread running");
        try {
            try {
                DatagramPacket dataPacket = new DatagramPacket(new byte[this.packetLength], this.packetLength);
                while (true) {
                    this.dataSocket.receive(dataPacket);
                    int l = dataPacket.getLength();
                    byte[] b = new byte[l];
                    System.arraycopy(dataPacket.getData(), 0, b, 0, l);
                    this.mq.addMessage(b);
                    dataPacket.setLength(this.packetLength);
                }
            }
            catch (Exception e) {
                this.logger.fatal((Object)("UDPListener thread dying - " + e.getMessage()), (Throwable)e);
                this.dataSocket.close();
            }
        }
        catch (Throwable throwable) {
            this.dataSocket.close();
            throw throwable;
        }
    }
}

