/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.LoggerModule.log4j;

import com.n2bb.LoggerModule.log4j.UDPWriter;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class UDPAppender
extends AppenderSkeleton {
    static final String TAB = "    ";
    private UDPWriter udpWriter = null;
    private String UDPHost;
    private int UDPPort;

    public synchronized void close() {
        this.closed = true;
        this.udpWriter = null;
    }

    public void append(LoggingEvent event) {
        int len;
        if (!this.isAsSevereAsThreshold((Priority)event.getLevel())) {
            return;
        }
        if (this.udpWriter == null) {
            try {
                this.udpWriter = new UDPWriter(this.UDPHost, this.UDPPort);
            }
            catch (Exception e) {
                LogLog.error((String)e.getMessage(), (Throwable)e);
            }
        }
        String buffer = this.layout.format(event);
        try {
            this.udpWriter.write(buffer);
        }
        catch (Exception e) {
            LogLog.error((String)e.getMessage(), (Throwable)e);
        }
        String[] s = event.getThrowableStrRep();
        if (s != null && (len = s.length) > 0) {
            try {
                this.udpWriter.write(s[0]);
            }
            catch (Exception e) {
                LogLog.error((String)e.getMessage(), (Throwable)e);
            }
            for (int i = 1; i < len; ++i) {
                try {
                    this.udpWriter.write(TAB + s[i].substring(1));
                    continue;
                }
                catch (Exception e) {
                    LogLog.error((String)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public boolean requiresLayout() {
        return true;
    }

    public void setUDPHost(String UDPHost) {
        this.UDPHost = UDPHost;
    }

    public void setUDPPort(int UDPPort) {
        this.UDPPort = UDPPort;
    }
}

