/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.LoggerModule.log4j;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.log4j.helpers.LogLog;

public class UDPWriter {
    private int UDPPort = 4488;
    private String UDPHost;
    private InetAddress address;
    private DatagramSocket ds;

    public UDPWriter(String UDPHost, int UDPPort) throws Exception {
        LogLog.debug((String)"constructing UDPWriter...");
        this.UDPHost = UDPHost;
        this.UDPPort = UDPPort;
        try {
            this.address = InetAddress.getByName(UDPHost);
        }
        catch (UnknownHostException e) {
            LogLog.error((String)("could not find " + UDPHost + " - all logging will fail - " + e.getMessage()), (Throwable)e);
            throw e;
        }
        try {
            this.ds = new DatagramSocket();
        }
        catch (SocketException e) {
            LogLog.error((String)("Could not instantiate DatagramSocket to " + UDPHost + ". All logging will FAIL."), (Throwable)e);
            throw e;
        }
        try {
            LogLog.debug((String)("socket send buffer size..." + this.ds.getSendBufferSize()));
        }
        catch (SocketException e) {
            LogLog.error((String)"unable to get socket's send buffer size");
            throw e;
        }
    }

    public void write(String string) throws IOException {
        byte[] bytes = string.getBytes("UTF-8");
        DatagramPacket packet = new DatagramPacket(bytes, bytes.length, this.address, this.UDPPort);
        if (this.ds != null) {
            this.ds.send(packet);
        }
    }

    public void flush() {
    }

    public void close() {
    }
}

