/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.LoggerModule;

import com.n2bb.LoggerModule.LogSettingsClient;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.LogLog;

public class LoggerWriter {
    public static final String SERVER_LOGGERS = System.getProperty("SERVER_LOGGERS", "/usr/local/n2bb/logger/conf/ServerLoggers.xml");
    private static LoggerWriter instance;
    private Logger logger;
    private static final String BMSSERVER = "BMSSERVER";
    public static final String BASE_MODULE_NAME = "module";
    static final String defaultNameService = "corbaloc::NameServer:5000/NameService";

    public static synchronized LoggerWriter getInstance() {
        if (instance == null) {
            instance = new LoggerWriter();
        }
        return instance;
    }

    private LoggerWriter() {
    }

    private void log(String msg) {
        if (this.logger == null) {
            LogLog.debug((String)msg);
        } else {
            this.logger.info((Object)msg);
        }
    }

    public void initLogger() {
        this.logger = Logger.getLogger(LoggerWriter.class);
    }

    private String getLoggers(String serverLevels) {
        this.log("Creating XML for servers from '" + serverLevels + "'");
        String loggers = "";
        String baseLevel = "INFO";
        String bmsServerLevel = "INFO";
        StringTokenizer token = new StringTokenizer(serverLevels.trim(), ";");
        while (token.hasMoreElements()) {
            String item = (String)token.nextElement();
            String[] serverLevel = item.split("\\.");
            if (serverLevel.length == 2) {
                String server = serverLevel[0].toUpperCase();
                String level = serverLevel[1];
                if (server.equals("ISA")) {
                    baseLevel = level;
                    continue;
                }
                if (server.equals(BMSSERVER)) {
                    bmsServerLevel = level;
                    continue;
                }
                loggers = loggers + this.getServerLogger(server, level);
                continue;
            }
            this.log("Skipping invalid server.level = " + item);
        }
        return loggers + this.getServerLogger(BMSSERVER, bmsServerLevel) + this.getBaseLogger(baseLevel);
    }

    private String getServerLogger(String server, String level) {
        String loggerName = "module." + server;
        String logger = "<logger name=\"" + loggerName + "\" additivity=\"true\">\n" + "      <level value=\"" + level + "\"/>\n";
        if (server.equals(BMSSERVER)) {
            logger = logger + "      <appender-ref ref=\"BMSSERVER_FILE\"/>\n";
        }
        return logger + "</logger>\n";
    }

    private String getBaseLogger(String level) {
        return "<logger name=\"module\" additivity=\"false\">\n    <level value=\"" + level + "\"/>\n" + "    <appender-ref ref=\"CENTRAL_LOGGER\"/>\n" + "</logger>";
    }

    public void writeCategories(String serverLevels) throws IOException {
        String xml = this.getLoggers(serverLevels);
        File file = new File(SERVER_LOGGERS);
        this.log("Deleting old " + SERVER_LOGGERS);
        if (file.exists()) {
            file.delete();
        }
        this.log("Writing new " + SERVER_LOGGERS);
        FileWriter os = new FileWriter(file);
        os.write(xml);
        os.close();
        this.log("Wrote new " + SERVER_LOGGERS);
    }

    public static void main(String[] args) throws Exception {
        String nameService;
        if (args.length < 1) {
            System.out.println("Using default nameService = corbaloc::NameServer:5000/NameService");
            nameService = defaultNameService;
        } else {
            nameService = args[0];
        }
        LogSettingsClient settingsClient = new LogSettingsClient(nameService);
        LoggerWriter.getInstance().writeCategories(settingsClient.getLogSettings());
    }
}

