/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeUtility;
import org.apache.axiom.attachments.impl.AbstractPart;
import org.apache.axiom.attachments.impl.BufferUtils;
import org.apache.axiom.attachments.utils.BAAInputStream;
import org.apache.axiom.om.OMException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PartOnMemoryEnhanced
extends AbstractPart {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$axiom$attachments$impl$PartOnMemoryEnhanced == null ? (class$org$apache$axiom$attachments$impl$PartOnMemoryEnhanced = PartOnMemoryEnhanced.class$("org.apache.axiom.attachments.impl.PartOnMemoryEnhanced")) : class$org$apache$axiom$attachments$impl$PartOnMemoryEnhanced));
    ArrayList data;
    int length;
    static /* synthetic */ Class class$org$apache$axiom$attachments$impl$PartOnMemoryEnhanced;

    PartOnMemoryEnhanced(Hashtable headers, ArrayList data, int length) {
        super(headers);
        this.data = data;
        this.length = length;
    }

    public DataHandler getDataHandler() throws MessagingException {
        MyByteArrayDataSource ds = new MyByteArrayDataSource();
        return new MyDataHandler(ds);
    }

    public String getFileName() throws MessagingException {
        return null;
    }

    public InputStream getInputStream() throws IOException, MessagingException {
        return new BAAInputStream(this.data, this.length);
    }

    public long getSize() throws MessagingException {
        return this.length;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class MyByteArrayDataSource
    implements DataSource {
        MyByteArrayDataSource() {
        }

        public String getContentType() {
            String ct = PartOnMemoryEnhanced.this.getHeader("content-type");
            return ct == null ? "application/octet-stream" : ct;
        }

        public InputStream getInputStream() throws IOException {
            BAAInputStream is = new BAAInputStream(PartOnMemoryEnhanced.this.data, PartOnMemoryEnhanced.this.length);
            String cte = null;
            try {
                cte = PartOnMemoryEnhanced.this.getContentTransferEncoding();
                if (cte != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Start Decoding stream");
                    }
                    return MimeUtility.decode((InputStream)is, (String)cte);
                }
            }
            catch (MessagingException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Stream Failed decoding");
                }
                throw new OMException(e);
            }
            return is;
        }

        public String getName() {
            return "MyByteArrayDataSource";
        }

        public OutputStream getOutputStream() throws IOException {
            throw new IOException("Not Supported");
        }
    }

    class MyDataHandler
    extends DataHandler {
        DataSource ds;

        public MyDataHandler(DataSource ds) {
            super(ds);
            this.ds = ds;
        }

        public void writeTo(OutputStream os) throws IOException {
            InputStream is = this.ds.getInputStream();
            if (is instanceof BAAInputStream) {
                ((BAAInputStream)is).writeTo(os);
            } else {
                BufferUtils.inputStream2OutputStream(is, os);
            }
        }
    }
}

