/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.saas.rules.custom;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.conf.IAutoFillVariableProvider;
import java.util.List;

public class SaaSAssetIdGenerator
implements IAutoFillVariableProvider {
    private static final int DIGITIS_SIZE = 16;

    public String getValue(Title title, Asset asset) {
        return this.getPrefix(asset) + this.getNewId(this.getPosition(title, asset));
    }

    private int getPosition(Title title, Asset asset) {
        List allAssetsInTree = title.getAsset().getAllAssets(false);
        for (int i = 0; i < allAssetsInTree.size(); ++i) {
            if (!((Asset)allAssetsInTree.get(i)).equals(asset)) continue;
            return i;
        }
        return -1;
    }

    private String getPrefix(Asset asset) {
        String assetType = asset.getAssetType();
        if (assetType == null || assetType.length() < 2) {
            return "CMXX";
        }
        return "CM" + assetType.substring(0, 2);
    }

    private String getNewId(int assetPositionInTree) {
        long time = System.currentTimeMillis();
        int randomSize = 16 - String.valueOf(assetPositionInTree).length() - String.valueOf(time).length();
        String randomNumber = this.generateRandomNumber(randomSize);
        String id = String.valueOf(assetPositionInTree) + randomNumber + time;
        return id;
    }

    public String generateRandomNumber(Integer numOfNumber) {
        String uuid = "";
        for (int i = 0; i < numOfNumber; ++i) {
            uuid = uuid + (int)(Math.random() * 10.0);
        }
        return uuid;
    }
}

