/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.saas.rules.custom.normalization;

import com.ericsson.saas.rules.custom.NameLookup;
import com.ericsson.saas.rules.custom.RulesUtil;
import com.tandbergtv.cms.rules.customrules.CustomNormalizationRule;
import com.tandbergtv.cms.rules.customrules.CustomRuleParameter;
import com.tandbergtv.marvin.udt.RuleResults;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class AddFieldValues
implements CustomNormalizationRule {
    private static Logger log = Logger.getLogger(AddFieldValues.class);
    private static final String SAAS_ADD_FIELD_VALUES = "saasAddFieldValues";
    private static final String FIELD_TO_ADD_XPATH = "fieldToAddXpath";
    private static final String ASSET_TYPE = "assetType";
    private static final String FIELD_CRITERIA_XPATH = "fieldCriteriaXPath";
    private static final String FIELD_CRITERIA_VALUE = "fieldCriteriaValue";
    private static final String FIELD_VALUES_TO_ADD = "fieldValuesToAdd";
    private static final String MULTIPLICITY_POSITION = "multiplicityPosition";

    public RuleResults runRule(Map<String, Object> parameters, Title title) {
        String assetType = (String)parameters.get(ASSET_TYPE);
        List assets = title.getAssets(assetType);
        log.debug((Object)String.format("Found %d %s assets to evaluate on title %d.", assets.size(), assetType, title.getId()));
        for (Asset asset : assets) {
            String fieldCriteriaXpath = (String)parameters.get(FIELD_CRITERIA_XPATH);
            String criteria = (String)parameters.get(FIELD_CRITERIA_VALUE);
            Field criteriaField = asset.getField(fieldCriteriaXpath);
            if (criteriaField != null && criteriaField.getValue() != null) {
                String criteriaFieldValue = criteriaField.getValue();
                if (Pattern.matches(criteria, criteriaFieldValue)) {
                    log.debug((Object)String.format("The value %s matched the criteria %s", criteriaFieldValue, criteria));
                    String fieldToAddXpath = (String)parameters.get(FIELD_TO_ADD_XPATH);
                    List existingFieldValues = asset.getFields(fieldToAddXpath);
                    log.debug((Object)("Field List size: " + existingFieldValues.size()));
                    if (existingFieldValues.isEmpty()) {
                        List<String> fieldValues = RulesUtil.stringDelimToList(";", (String)parameters.get(FIELD_VALUES_TO_ADD));
                        int position = 0;
                        Integer multiplicityPosition = (Integer)parameters.get(MULTIPLICITY_POSITION);
                        for (String value : fieldValues) {
                            Field field = new Field(fieldToAddXpath, value);
                            RulesUtil.updateFieldIndices(field, ++position, multiplicityPosition);
                            asset.addField(field);
                            log.info((Object)String.format("Added a new value %s to %s.", value, fieldToAddXpath));
                        }
                        continue;
                    }
                    log.warn((Object)"Field List is not empty. No Fields added.");
                    continue;
                }
                log.warn((Object)String.format("The value %s haven't matched the criteria %s", criteriaFieldValue, criteria));
                continue;
            }
            log.warn((Object)"This asset hasn't the field to evaluate.");
        }
        return new RuleResults(title, true);
    }

    public String getName(Locale locale) {
        return NameLookup.lookupValue(SAAS_ADD_FIELD_VALUES, locale);
    }

    public List<CustomRuleParameter> getParameters(Locale locale) {
        ArrayList<CustomRuleParameter> variables = new ArrayList<CustomRuleParameter>();
        variables.add(new CustomRuleParameter(ASSET_TYPE, NameLookup.lookupValue(ASSET_TYPE, locale), CustomRuleParameter.ParameterDataType.STRING));
        variables.add(new CustomRuleParameter(FIELD_CRITERIA_XPATH, NameLookup.lookupValue(FIELD_CRITERIA_XPATH, locale), CustomRuleParameter.ParameterDataType.STRING));
        variables.add(new CustomRuleParameter(FIELD_CRITERIA_VALUE, NameLookup.lookupValue(FIELD_CRITERIA_VALUE, locale), CustomRuleParameter.ParameterDataType.STRING));
        variables.add(new CustomRuleParameter(FIELD_TO_ADD_XPATH, NameLookup.lookupValue(FIELD_TO_ADD_XPATH, locale), CustomRuleParameter.ParameterDataType.STRING));
        variables.add(new CustomRuleParameter(FIELD_VALUES_TO_ADD, NameLookup.lookupValue(FIELD_VALUES_TO_ADD, locale), CustomRuleParameter.ParameterDataType.STRING));
        variables.add(new CustomRuleParameter(MULTIPLICITY_POSITION, NameLookup.lookupValue(MULTIPLICITY_POSITION, locale), CustomRuleParameter.ParameterDataType.INTEGER));
        return variables;
    }
}

