/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.saas.rules.custom.normalization;

import com.ericsson.saas.rules.custom.NameLookup;
import com.ericsson.saas.rules.custom.RulesUtil;
import com.tandbergtv.cms.rules.customrules.CustomNormalizationRule;
import com.tandbergtv.cms.rules.customrules.CustomRuleParameter;
import com.tandbergtv.marvin.udt.RuleResults;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CreateAssets
implements CustomNormalizationRule {
    private static Logger log = Logger.getLogger(CreateAssets.class);
    private static final String SAAS_CREATE_ASSETS = "saasCreateAssets";
    private static final String PROFILE_NAMES = "profileNames";
    private static final String NUMBER_OF_ASSETS = "numberOfAssets";
    private static final String ASSET_TYPE = "assetType";
    private static final String ASSET_CLASS_XPATH = "/Fields/AssetClass";
    private static final String CREATION_INFO_CREATE_DATE_XPATH = "/Fields/CreationInfo/CreateDate";
    private static final String ASSET_NAME_XPATH = "/Fields/AssetName";
    private static final String TRANSCODED_MOVIE_FORMAT_XPATH = "/Fields/CustomFields/CustomField[@name=TranscodedMovieFormat]/@value";
    private static final String TRANSCODED_PREVIEW_FORMAT_XPATH = "/Fields/CustomFields/CustomField[@name=TranscodedPreviewFormat]/@value";
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public RuleResults runRule(Map<String, Object> parameters, Title title) {
        Group.GroupType assetType;
        Integer numberOfAssets = (Integer)parameters.get(NUMBER_OF_ASSETS);
        List<String> profileNames = RulesUtil.csvToList((String)parameters.get(PROFILE_NAMES));
        try {
            String assetTypeName = (String)parameters.get(ASSET_TYPE);
            assetType = Group.GroupType.valueOf((String)assetTypeName.trim().toUpperCase());
        }
        catch (Exception e) {
            log.error((Object)"The assetTypeName is not valid", (Throwable)e);
            return new RuleResults(title, false);
        }
        if (numberOfAssets.intValue() != profileNames.size()) {
            log.error((Object)"profileNames.size() != numberOfAssets");
            return new RuleResults(title, false);
        }
        String creationDate = this.getFormatedCreationDate();
        for (String profileName : profileNames) {
            if (this.assetExists(title, profileName, assetType)) continue;
            this.createAsset(title, profileName, creationDate, assetType);
        }
        return new RuleResults(title, true);
    }

    private String getFormatedCreationDate() {
        return this.dateFormat.format(new Date());
    }

    private void createAsset(Title title, String profileName, String creationDate, Group.GroupType assetType) {
        Group asset = new Group();
        asset.setType(assetType);
        asset.updateFieldValue(ASSET_CLASS_XPATH, assetType.name().toLowerCase());
        asset.updateFieldValue(ASSET_NAME_XPATH, profileName);
        asset.updateFieldValue(CREATION_INFO_CREATE_DATE_XPATH, creationDate);
        String transcodedFormatField = Group.GroupType.PREVIEW.equals((Object)assetType) ? TRANSCODED_PREVIEW_FORMAT_XPATH : TRANSCODED_MOVIE_FORMAT_XPATH;
        asset.updateFieldValue(transcodedFormatField, profileName);
        title.getAsset().addChild((Asset)asset);
    }

    private boolean assetExists(Title title, String name, Group.GroupType assetType) {
        List assets = title.getAsset().getAllAssetsOfType(assetType.name());
        for (Asset asset : assets) {
            Field assetName = asset.getFirstField(ASSET_NAME_XPATH);
            if (assetName == null || assetName.getValue() == null || !assetName.getValue().equals(name)) continue;
            return true;
        }
        return false;
    }

    public String getName(Locale locale) {
        return NameLookup.lookupValue(SAAS_CREATE_ASSETS, locale);
    }

    public List<CustomRuleParameter> getParameters(Locale locale) {
        ArrayList<CustomRuleParameter> variables = new ArrayList<CustomRuleParameter>();
        variables.add(new CustomRuleParameter(ASSET_TYPE, NameLookup.lookupValue(ASSET_TYPE, locale), CustomRuleParameter.ParameterDataType.STRING));
        variables.add(new CustomRuleParameter(NUMBER_OF_ASSETS, NameLookup.lookupValue(NUMBER_OF_ASSETS, locale), CustomRuleParameter.ParameterDataType.INTEGER));
        variables.add(new CustomRuleParameter(PROFILE_NAMES, NameLookup.lookupValue(PROFILE_NAMES, locale), CustomRuleParameter.ParameterDataType.STRING));
        return variables;
    }
}

