/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.saas.rules.custom.normalization;

import com.ericsson.saas.rules.custom.NameLookup;
import com.ericsson.saas.rules.custom.RulesUtil;
import com.ericsson.saas.rules.custom.SaaSAssetIdGenerator;
import com.tandbergtv.cms.rules.customrules.CustomNormalizationRule;
import com.tandbergtv.cms.rules.customrules.CustomRuleParameter;
import com.tandbergtv.marvin.udt.RuleResults;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class SetAssetId
implements CustomNormalizationRule {
    private static Logger log = Logger.getLogger(SetAssetId.class);
    private static final String SAAS_SET_ASSET_ID = "saasSetAssetId";
    private static final String ASSET_ID_XPATH = "/Fields/Identifier/Id";
    private static final String ASSET_TYPES = "assetTypes";
    static final SaaSAssetIdGenerator idGenerator = new SaaSAssetIdGenerator();

    public RuleResults runRule(Map<String, Object> parameters, Title title) {
        List<String> assetTypes = RulesUtil.csvToList((String)parameters.get(ASSET_TYPES));
        for (String assetType : assetTypes) {
            List assets = title.getAssets(assetType);
            log.debug((Object)String.format("Found %d %s assets.", assets.size(), assetType));
            for (Asset asset : assets) {
                String assetIdValue;
                Field assetId = asset.getField(ASSET_ID_XPATH);
                log.debug((Object)("Asset Id field: " + assetId));
                if (assetId == null) {
                    assetIdValue = this.generateAssetId(title, asset);
                    asset.updateFieldValue(ASSET_ID_XPATH, assetIdValue);
                    log.debug((Object)String.format("Asset Id set for a %s. Value: %s.", assetType, assetIdValue));
                    continue;
                }
                assetIdValue = assetId.getValue();
                log.debug((Object)String.format("Got Asset Id for a %s. Since already set it won't be changed. Value: %s.", assetType, assetIdValue));
            }
        }
        return new RuleResults(title, true);
    }

    private String generateAssetId(Title title, Asset asset) {
        return idGenerator.getValue(title, asset);
    }

    public String getName(Locale locale) {
        return NameLookup.lookupValue(SAAS_SET_ASSET_ID, locale);
    }

    public List<CustomRuleParameter> getParameters(Locale locale) {
        ArrayList<CustomRuleParameter> variables = new ArrayList<CustomRuleParameter>();
        variables.add(new CustomRuleParameter(ASSET_TYPES, NameLookup.lookupValue(ASSET_TYPES, locale), CustomRuleParameter.ParameterDataType.STRING));
        return variables;
    }
}

