/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.saas.rules.custom.normalization;

import com.ericsson.saas.rules.custom.NameLookup;
import com.tandbergtv.cms.rules.customrules.CustomNormalizationRule;
import com.tandbergtv.cms.rules.customrules.CustomRuleParameter;
import com.tandbergtv.marvin.udt.RuleResults;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

@Deprecated
public class SetEncryptedAssetId
implements CustomNormalizationRule {
    protected static Logger log = Logger.getLogger(SetEncryptedAssetId.class);
    protected static final String TRANSCODED_MOVIE_FORMAT_XPATH = "/Fields/CustomFields/CustomField[@name=TranscodedMovieFormat]/@value";
    protected static final String TRANSCODE_PROFILE_XPATH = "/Fields/CustomFields/CustomField[@name=TranscodeProfile]/@value";
    protected static final String ASSET_ID_XPATH = "/Fields/Identifier/Id";
    protected static final String ASSET_ENCRYPTED_XPATH = "/Fields/Encryption/Asset/Id";
    protected static final String SAAS_SET_ENCRYPTED_ASSET_ID = "saasSetEncryptedAssetId";

    public RuleResults runRule(Map<String, Object> parameters, Title title) {
        List allMovieAssets = title.getAsset().getAllAssetsOfType(Group.GroupType.MOVIE.name());
        boolean modified = false;
        for (Asset movie : allMovieAssets) {
            String[] profiles;
            Field assetIdField;
            if (!this.isOriginal(movie) || (assetIdField = movie.getField(ASSET_ID_XPATH)) == null) continue;
            for (String profile : profiles = this.getOriginalMovieProfiles(movie)) {
                for (Asset tm : allMovieAssets) {
                    if (!this.isTranscodedMovieWithProfile(tm, profile)) continue;
                    modified = true;
                    tm.updateFieldValue(ASSET_ENCRYPTED_XPATH, assetIdField.getValue());
                }
            }
        }
        return new RuleResults(title, modified);
    }

    private boolean isTranscodedMovieWithProfile(Asset transcodedMovie, String profile) {
        Field tmfField = transcodedMovie.getField(TRANSCODED_MOVIE_FORMAT_XPATH);
        boolean b = tmfField != null && tmfField.getValue() != null && tmfField.getValue().equals(profile);
        return b;
    }

    private String[] getOriginalMovieProfiles(Asset movie) {
        return movie.getField(TRANSCODE_PROFILE_XPATH).getValue().split("[, \t]");
    }

    private boolean isOriginal(Asset movie) {
        boolean isOriginal = movie.getField(TRANSCODE_PROFILE_XPATH) != null;
        return isOriginal;
    }

    public String getName(Locale locale) {
        return NameLookup.lookupValue(SAAS_SET_ENCRYPTED_ASSET_ID, locale);
    }

    public List<CustomRuleParameter> getParameters(Locale locale) {
        return new ArrayList<CustomRuleParameter>();
    }
}

