/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.saas.rules.custom.normalization;

import com.ericsson.saas.rules.custom.NameLookup;
import com.tandbergtv.cms.rules.customrules.CustomNormalizationRule;
import com.tandbergtv.cms.rules.customrules.CustomRuleParameter;
import com.tandbergtv.marvin.udt.RuleResults;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.Item;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class SetProductBasedOnCategory
implements CustomNormalizationRule {
    private static final String CATEGORY_XPATH = "/Fields/Categories/Category/Text";
    private static final String PRODUCT_XPATH = "/Fields/ProductInfo/Name";
    protected static Logger log = Logger.getLogger(SetProductBasedOnCategory.class);

    public RuleResults runRule(Map<String, Object> parameters, Title title) {
        List tal = title.getAsset().getAllAssetsOfType(Item.ItemType.TITLE.name());
        if (tal == null || tal.isEmpty()) {
            String errorMsg = "Something terribly wrong happened. This title doesn't hava a title asset: " + title;
            log.error((Object)errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        Asset titleAsset = (Asset)tal.get(0);
        String category = this.getCategory(titleAsset);
        if (category == null || category.isEmpty()) {
            return new RuleResults(title, false);
        }
        String product = this.getProductFromCategory(category);
        for (Asset asset : title.getAllAssets(false)) {
            asset.updateFieldValue(PRODUCT_XPATH, product);
        }
        return new RuleResults(title, true);
    }

    private String getProductFromCategory(String category) {
        String[] categories = category.split("[/\\\\]+");
        return categories[0].isEmpty() ? categories[1] : categories[0];
    }

    private String getCategory(Asset titleAsset) {
        Field categoryField = titleAsset.getField(CATEGORY_XPATH);
        if (categoryField == null) {
            return null;
        }
        return categoryField.getValue();
    }

    public String getName(Locale locale) {
        return NameLookup.lookupValue("saasSetProductBasedOnCategory", locale);
    }

    public List<CustomRuleParameter> getParameters(Locale locale) {
        return new ArrayList<CustomRuleParameter>();
    }
}

