/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.saas.rules.custom.normalization;

import com.ericsson.saas.rules.custom.NameLookup;
import com.tandbergtv.cms.rules.customrules.CustomNormalizationRule;
import com.tandbergtv.cms.rules.customrules.CustomRuleParameter;
import com.tandbergtv.marvin.udt.RuleResults;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class SetTitleCreationDate
implements CustomNormalizationRule {
    private static Logger logger = Logger.getLogger(SetTitleCreationDate.class);
    private static final String TITLE_CREATION_DATE_XPATH = "/Fields/CustomFields/CustomField[@name=TITLE_CREATION_DATE]/@value";
    private static final String SAAS_SET_TITLE_CREATION_DATE = "saasSetTitleCreationDate";
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public RuleResults runRule(Map<String, Object> parameters, Title title) {
        logger.debug((Object)("Setting title creation date for title #" + title.getId()));
        title.getAsset().updateFieldValue(TITLE_CREATION_DATE_XPATH, dateFormat.format(new Date()));
        return new RuleResults(title, true);
    }

    public String getName(Locale locale) {
        return NameLookup.lookupValue(SAAS_SET_TITLE_CREATION_DATE, locale);
    }

    public List<CustomRuleParameter> getParameters(Locale locale) {
        return new ArrayList<CustomRuleParameter>();
    }
}

