/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.saas.common.ffmpeg;

import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class GetHDContent
implements ActionHandler {
    private static final long serialVersionUID = -1926505656183100809L;

    public void execute(ExecutionContext executionContext) throws Exception {
        String[] videoFpsArray;
        String[] audioHertzArray;
        String[] audioBitRateArray;
        String[] bitRateArray;
        String[] videoBitRateArray;
        String[] videoResolutionArray;
        String videoResolution = this.getStringValue(executionContext, "videoResolution");
        boolean isHDContent = false;
        if (videoResolution != null && (videoResolutionArray = videoResolution.split("x")).length == 2) {
            String strVerticalResolution = videoResolutionArray[1];
            try {
                int verticalResolution = Integer.parseInt(strVerticalResolution);
                if (verticalResolution >= 720) {
                    isHDContent = true;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        executionContext.setVariable("hdContent", (Object)isHDContent);
        String bitRate = this.getStringValue(executionContext, "bitRate");
        String videoBitRate = this.getStringValue(executionContext, "videoBitRate");
        if (videoBitRate != null && (videoBitRateArray = videoBitRate.split(" ")).length == 2) {
            videoBitRate = videoBitRateArray[0];
        }
        if ((videoBitRate == null || videoBitRate.isEmpty()) && bitRate != null && !bitRate.isEmpty() && (bitRateArray = bitRate.split(" ")).length == 2) {
            videoBitRate = bitRateArray[0];
        }
        executionContext.setVariable("videoBitRate", (Object)videoBitRate);
        String audioBitRate = this.getStringValue(executionContext, "audioBitRate");
        if (audioBitRate != null && (audioBitRateArray = audioBitRate.split(" ")).length == 2) {
            audioBitRate = audioBitRateArray[0];
        }
        executionContext.setVariable("audioBitRate", (Object)audioBitRate);
        String audioHertz = this.getStringValue(executionContext, "audioHertz");
        if (audioHertz != null && (audioHertzArray = audioHertz.split(" ")).length == 2) {
            audioHertz = audioHertzArray[0];
        }
        executionContext.setVariable("audioHertz", (Object)audioHertz);
        String videoFps = this.getStringValue(executionContext, "videoFps");
        if (videoFps != null && (videoFpsArray = videoFps.split(" ")).length == 2) {
            videoFps = videoFpsArray[0];
        }
        executionContext.setVariable("videoFps", (Object)videoFps);
        String duration = this.getStringValue(executionContext, "duration");
        if (duration != null && duration.length() > "00:00:00".length() && duration.contains(".")) {
            duration = duration.substring(0, duration.indexOf("."));
        }
        executionContext.setVariable("duration", (Object)duration);
    }

    private String getStringValue(ExecutionContext context, String variableName) {
        Object value = context.getVariable(variableName);
        return value != null ? value.toString() : null;
    }
}

