/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.saas.common.ftp;

public class FTPConnectionDetails {
    private static final String FTP_PROTOCOL_PREFIX = "ftp://";
    private String username;
    private String password;
    private String host;
    private String path;
    private String completeUrl;

    public FTPConnectionDetails(String url) {
        try {
            this.completeUrl = url;
            int colonInd = url.indexOf(":", FTP_PROTOCOL_PREFIX.length());
            this.username = url.substring(6, colonInd);
            int atInd = url.indexOf("@");
            this.password = url.substring(colonInd + 1, atInd);
            int slashInd = url.indexOf("/", atInd);
            if (slashInd != -1) {
                this.host = url.substring(atInd + 1, slashInd);
                this.path = url.substring(slashInd);
            } else {
                this.host = url.substring(atInd + 1);
                this.path = "/";
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Not a valid ftp url", e);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public String getUrl() {
        return this.completeUrl;
    }

    public String toString() {
        return this.getUrl();
    }
}

