/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.saas.common.ftp;

import com.ericsson.saas.common.ftp.FTPConnectionDetails;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.log4j.Logger;

public class SaaSFTPClient {
    private static final Logger logger = Logger.getLogger(SaaSFTPClient.class);
    private FTPConnectionDetails connectionDetails;
    private FTPClient ftpClientInstance;

    public SaaSFTPClient(String ftpPath) throws IOException {
        this.connectionDetails = new FTPConnectionDetails(ftpPath);
    }

    protected FTPClient getNewConnection() throws IOException {
        if (this.ftpClientInstance == null) {
            this.ftpClientInstance = new FTPClient();
        }
        this.closeConnection();
        this.ftpClientInstance.connect(this.connectionDetails.getHost());
        if (!FTPReply.isPositiveCompletion((int)this.ftpClientInstance.getReplyCode())) {
            throw new IOException("It was not possible to connect to " + this.connectionDetails + ": " + this.ftpClientInstance.getReplyString());
        }
        boolean successfulLogin = this.ftpClientInstance.login(this.connectionDetails.getUsername(), this.connectionDetails.getPassword());
        if (!successfulLogin) {
            throw new IOException("Invalid login");
        }
        this.ftpClientInstance.enterLocalPassiveMode();
        return this.ftpClientInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.closeConnection();
        }
        finally {
            super.finalize();
        }
    }

    public void closeConnection() throws IOException {
        if (this.ftpClientInstance != null && this.ftpClientInstance.isConnected()) {
            this.ftpClientInstance.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitPollTime(long pollTime) {
        SaaSFTPClient saaSFTPClient = this;
        synchronized (saaSFTPClient) {
            try {
                this.wait(pollTime * 1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void waitForCopyCompletion(long timeout, long timeBeforeCompletionIsAssumed, long pollTime, String incompleteSuffix) throws IOException {
        long totalTime = 0L;
        long waitTime = 0L;
        long lastFileSize = 0L;
        long lastTimestamp = 0L;
        while (true) {
            this.waitPollTime(pollTime);
            FTPClient ftp = this.getNewConnection();
            long currentFileSize = this.getFileSize(ftp, this.connectionDetails.getPath());
            long currentTimestamp = this.getTimestamp(ftp, this.connectionDetails.getPath());
            logger.debug((Object)("Waiting for copy completion of " + this.connectionDetails.getPath() + "\n\tTotal time=" + totalTime + "\tTime without file updates=" + waitTime + "\n\tFile Size=" + currentFileSize + "/" + lastFileSize + "\tTimestamp=" + currentTimestamp + "/" + lastTimestamp + "\t(current/last)"));
            if (currentFileSize != lastFileSize || currentTimestamp != lastTimestamp) {
                lastFileSize = currentFileSize;
                lastTimestamp = currentTimestamp;
                waitTime = 0L;
            } else if (incompleteSuffix == null || incompleteSuffix.equals("")) {
                if (waitTime > timeBeforeCompletionIsAssumed) {
                    logger.info((Object)String.format("File %s is assumed complete since its size hasn't modified for more than %d", this.connectionDetails.getPath(), timeBeforeCompletionIsAssumed));
                    return;
                }
                waitTime += pollTime;
            } else {
                if (!this.isSomeFileIncomplete(ftp, this.connectionDetails.getPath(), incompleteSuffix)) {
                    logger.info((Object)String.format("Copy completed of %s", this.connectionDetails.getPath()));
                    return;
                }
                waitTime += pollTime;
                logger.debug((Object)String.format("Copy in progress of %s", this.connectionDetails.getPath()));
            }
            if (totalTime > timeout) {
                logger.warn((Object)String.format("Timeout happened. Directory %s", this.connectionDetails.getPath()));
                throw new RuntimeException("Timeout");
            }
            totalTime += pollTime;
        }
    }

    private long getTimestamp(FTPClient ftp, String path) throws IOException {
        FTPFile[] files;
        long mostRecentTimestamp = -1L;
        for (FTPFile file : files = ftp.listFiles(path)) {
            long thisFileTimestamp = file.getTimestamp().getTimeInMillis();
            if (thisFileTimestamp <= mostRecentTimestamp) continue;
            mostRecentTimestamp = thisFileTimestamp;
        }
        return mostRecentTimestamp;
    }

    private boolean isSomeFileIncomplete(FTPClient ftpClient, String path, String incompleteSuffix) throws IOException {
        FTPFile[] files;
        boolean isSomeFileIncomplete = false;
        for (FTPFile file : files = ftpClient.listFiles(path)) {
            String fileName = file.getName();
            if (!fileName.endsWith(incompleteSuffix)) continue;
            isSomeFileIncomplete = true;
            logger.debug((Object)String.format("Incomplete file found on directory %s. File Name: %s", path, fileName));
            break;
        }
        return isSomeFileIncomplete;
    }

    private long getFileSize(FTPClient ftpClient, String path) throws IOException {
        FTPFile[] files;
        long result = 0L;
        for (FTPFile file : files = ftpClient.listFiles(path)) {
            if (file.isFile()) {
                result += file.getSize();
                continue;
            }
            if (!file.isDirectory()) continue;
            result += this.getFileSize(ftpClient, path + "/" + file.getName());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirectory() throws IOException {
        FTPClient ftp = this.getNewConnection();
        String currentWorkingDir = ftp.printWorkingDirectory();
        try {
            boolean bl = ftp.changeWorkingDirectory(this.connectionDetails.getPath());
            return bl;
        }
        finally {
            ftp.changeWorkingDirectory(currentWorkingDir);
        }
    }

    public void download(String toDir) throws IOException {
        if (this.isDirectory()) {
            this.downloadDirectory(this.connectionDetails.getPath(), toDir);
        } else {
            this.downloadFile(this.connectionDetails.getPath(), toDir);
        }
    }

    private void downloadDirectory(String fromDir, String toDir) throws IOException {
        FTPFile[] files;
        FileUtils.forceMkdir((File)new File(toDir));
        FTPClient ftp = this.getNewConnection();
        for (FTPFile file : files = ftp.listFiles(fromDir)) {
            this.downloadFile(fromDir + "/" + file.getName(), toDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFile(String fromFile, String toDir) throws IOException, FileNotFoundException {
        String toFile = toDir + File.separator + new File(fromFile).getName();
        FileOutputStream out = null;
        try {
            FTPClient ftp = this.getNewConnection();
            ftp.setFileType(2);
            out = new FileOutputStream(toFile);
            boolean result = ftp.retrieveFile(fromFile, (OutputStream)out);
            if (!result) {
                throw new IOException("It wasn't possible to download the file " + this.connectionDetails + " to " + toDir);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    public void delete() throws IOException {
        if (this.isDirectory()) {
            this.deleteDirectory(this.connectionDetails.getPath());
        } else {
            this.deleteFile(this.connectionDetails.getPath());
        }
    }

    private void deleteDirectory(String path) throws IOException {
        FTPFile[] files;
        FTPClient ftp = this.getNewConnection();
        for (FTPFile file : files = ftp.listFiles(path)) {
            this.deleteFile(path + "/" + file.getName());
        }
        boolean success = ftp.removeDirectory(path);
        if (!success) {
            throw new IOException("It wasn't possible to delete the directory " + this.connectionDetails);
        }
    }

    private void deleteFile(String path) throws IOException {
        FTPClient ftp = this.getNewConnection();
        boolean result = ftp.deleteFile(path);
        if (!result) {
            throw new IOException("It wasn't possible to delete the file " + this.connectionDetails);
        }
    }
}

