/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.saas.common.util;

import java.io.File;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class CheckResultSingleFileGetFileExtension
implements ActionHandler {
    private static final String slash = "/";
    private static final String transcodedFileNameFieldValueVariable = "transcodedFileNameFieldValue";
    private static final String transcodedFolderVariable = "transcodedFolder";
    private static final long serialVersionUID = 677551223152656799L;
    private static final Logger logger = Logger.getLogger(CheckResultSingleFileGetFileExtension.class);

    public void execute(ExecutionContext executionContext) throws Exception {
        String folder = this.getStringValue(executionContext, transcodedFolderVariable);
        if (folder == null || folder.isEmpty()) {
            throw new IllegalArgumentException("transcodedFolder is mandatory.");
        }
        String transcodedFileNameFieldValue = this.getStringValue(executionContext, transcodedFileNameFieldValueVariable);
        if (transcodedFileNameFieldValue != null && !transcodedFileNameFieldValue.isEmpty()) {
            folder = folder.substring(0, folder.indexOf(slash + transcodedFileNameFieldValue));
        }
        if (folder.endsWith(slash)) {
            folder = folder.substring(0, folder.length() - 1);
        }
        File transcodedFolder = new File(folder);
        int numberOfFiles = 0;
        if (!transcodedFolder.exists()) {
            throw new RuntimeException("Folder does not exist or is not readable : " + folder);
        }
        numberOfFiles = transcodedFolder.list().length;
        String isSingleFile = "false";
        String transcodedFilePath = "";
        String fileExtension = "";
        logger.info((Object)("Checking if is single file and get file extension for : " + folder));
        if (numberOfFiles == 1) {
            File transcodedResult = transcodedFolder.listFiles()[0];
            transcodedFilePath = transcodedResult.getAbsolutePath();
            if (!transcodedResult.isDirectory()) {
                isSingleFile = "true";
                fileExtension = transcodedResult.getName().split("\\.")[1];
            }
        }
        logger.info((Object)("Checking if is single file and get file extension FINISHED for : " + folder));
        executionContext.setVariable("transcodedIsSingleFile", (Object)isSingleFile);
        executionContext.setVariable("transcodedFileCompletePath", (Object)transcodedFilePath);
        executionContext.setVariable("transcodedFileExtension", (Object)fileExtension);
        executionContext.setVariable(transcodedFolderVariable, (Object)folder);
    }

    private String getStringValue(ExecutionContext context, String variableName) {
        Object value = context.getVariable(variableName);
        return value != null ? value.toString() : null;
    }
}

