/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.saas.common.util;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class HandleManifestFile
implements ActionHandler {
    private static final long serialVersionUID = -175238242913171745L;
    private static final Logger logger = Logger.getLogger(HandleManifestFile.class);
    private static final String MANIFEST_EXTENSION = ".m3u8";

    public void execute(ExecutionContext executionContext) throws Exception {
        String folder = this.getStringValue(executionContext, "transcodedFolder");
        logger.info((Object)String.format("Handling manifest files for the transcoded folder: %s", folder));
        File transcodedFolder = new File(folder);
        int numberOfFiles = 0;
        if (!transcodedFolder.exists()) {
            throw new RuntimeException(String.format("Folder does not exist or is not readable : %s", folder));
        }
        numberOfFiles = transcodedFolder.list().length;
        if (numberOfFiles > 1) {
            Object[] manifestFiles = transcodedFolder.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.getName().endsWith(HandleManifestFile.MANIFEST_EXTENSION);
                }
            });
            if (manifestFiles.length > 0) {
                Arrays.sort(manifestFiles);
                Object manifestFile = manifestFiles[0];
                logger.info((Object)String.format("Manifest file found: %s", ((File)manifestFile).getName()));
                StringBuilder transcodedFolderName = new StringBuilder(this.getStringValue(executionContext, "transcodedFolderName"));
                transcodedFolderName.append("/").append(((File)manifestFile).getName());
                executionContext.setVariable("transcodedFolderName", (Object)transcodedFolderName.toString());
            } else {
                logger.info((Object)String.format("No manifest file found for folder: %s", folder));
            }
        } else {
            logger.info((Object)String.format("Folder doesn't have more than one file: %s", folder));
        }
    }

    private String getStringValue(ExecutionContext context, String variableName) {
        Object value = context.getVariable(variableName);
        return value != null ? value.toString() : null;
    }
}

