/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.saas.contentprocessing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class ContentProcessingResetVariables
implements ActionHandler {
    private static final long serialVersionUID = -904667130355784530L;
    private static final Logger logger = Logger.getLogger(ContentProcessingResetVariables.class);
    static final String[] variablesToClear = new String[]{"transcodePresetValue", "transcoderType", "assetId", "location", "presets", "fileId", "hasNext", "transcodelocation", "transcodedFileName", "contentAssetCount", "contentAssetIdListValue", "contentAssetIdList", "contentAssetId", "hasNextAsset", "transcodedMovieFormatFieldValue", "transcodedIsSingleFile", "selectedMovieFileId", "transcodedFolder", "transcodedFileCompletePath", "transcodedFileExtension", "videoBitrate", "transcodedFolderName"};

    public void execute(ExecutionContext context) throws Exception {
        logger.info((Object)"Clearing variables to next Asset Type loop.");
        this.clearVariables(context, variablesToClear);
        if ("PREVIEW".equals(context.getVariable("assetType"))) {
            context.setVariable("assetType", (Object)"MOVIE");
            context.setVariable("transcodedMovieFormatField", (Object)"TranscodedMovieFormat");
        } else {
            context.setVariable("assetType", (Object)"");
        }
        logger.info((Object)("Asset type set to " + context.getVariable("assetType")));
    }

    private void clearVariables(ExecutionContext context, String ... variables) {
        for (String variable : variables) {
            Object value = context.getVariable(variable);
            logger.debug((Object)("Clearing variable " + variable));
            Serializable newValue = null;
            if (value == null) continue;
            if (value instanceof String) {
                newValue = "";
            } else if (value instanceof Integer) {
                newValue = new Integer(0);
            } else if (value instanceof Long) {
                newValue = new Long(0L);
            } else if (value instanceof List) {
                newValue = new ArrayList();
            } else if (value instanceof Boolean) {
                newValue = Boolean.FALSE;
            }
            context.setVariable(variable, (Object)newValue);
            logger.debug((Object)("Variable " + variable + " value set to " + newValue));
        }
    }
}

