/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.saas.distribution;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class UpdateLoopVariables
implements ActionHandler {
    private static final long serialVersionUID = -3698310938194148643L;
    private static final Logger logger = Logger.getLogger(UpdateLoopVariables.class);

    public void execute(ExecutionContext executionContext) throws Exception {
        String siteLookupKeys = this.getStringValue(executionContext, "siteLookupKeys");
        List<String> assetTypeLookupKeysList = this.convertCommaSepListtoList(siteLookupKeys);
        int loopIndex = this.getIntegerValue(executionContext, "assetTypeLookupKeyIndex", -1) + 1;
        String assetTypeLookupKey = assetTypeLookupKeysList.get(loopIndex).trim();
        String currentAssetType = assetTypeLookupKey.substring(0, assetTypeLookupKey.indexOf("-"));
        String currentLookupKey = assetTypeLookupKey.substring(assetTypeLookupKey.indexOf("-") + 1);
        boolean hasMoreAssetTypeLookupKeys = loopIndex + 1 < assetTypeLookupKeysList.size();
        String distributionFolderAssetTypePath = this.getStringValue(executionContext, "distributionFolderPath") + File.separator + currentAssetType;
        executionContext.setVariable("distributionFolderAssetTypePath", (Object)distributionFolderAssetTypePath);
        executionContext.setVariable("fileDistributionFolderAssetTypePath", (Object)distributionFolderAssetTypePath);
        executionContext.setVariable("currentAssetType", (Object)currentAssetType);
        executionContext.setVariable("currentLookupKey", (Object)currentLookupKey);
        executionContext.setVariable("hasMoreAssetTypeLookupKeys", (Object)hasMoreAssetTypeLookupKeys);
        executionContext.setVariable("assetTypeLookupKeyIndex", (Object)loopIndex);
    }

    private List<String> convertCommaSepListtoList(String commaSepList) {
        return Arrays.asList(commaSepList.split(","));
    }

    private String getStringValue(ExecutionContext context, String variableName) {
        Object value = context.getVariable(variableName);
        return value != null ? value.toString() : null;
    }

    private int getIntegerValue(ExecutionContext context, String variableName, int defaultValue) {
        int intValue = defaultValue;
        Object value = context.getVariable(variableName);
        if (value == null) {
            intValue = defaultValue;
        } else if (value instanceof Integer) {
            intValue = (Integer)value;
        } else {
            try {
                String stringValue = value.toString();
                if (stringValue.trim().length() == 0) {
                    return defaultValue;
                }
                intValue = Integer.parseInt(stringValue.trim());
            }
            catch (NumberFormatException e) {
                logger.warn((Object)("Failed to parse value: " + value + " to an integer when getting Asset Mapping Loop Index, " + "using default value: " + defaultValue), (Throwable)e);
            }
        }
        return intValue;
    }
}

