/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.saas.ingest.file;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class GetMetadataFilePath
implements ActionHandler {
    private static final Logger logger = Logger.getLogger(GetMetadataFilePath.class);
    private static final String TEMPLATE_FILE_PREFIX = "template";
    private static final String TEMPLATE_FILE_EXTENSION = ".XML";
    private static final String TEMPLATE_FILE_NAME_SEPARATOR = "_";
    private static final String ASSET_TYPE_MOVIE = "MOVIE";
    private static final long serialVersionUID = -2203969106226404517L;

    public void execute(ExecutionContext executionContext) throws Exception {
        String templateXMLDir = this.getStringValue(executionContext, "templateXMLDir");
        String assetType = this.getStringValue(executionContext, "assetType");
        if (assetType == null || assetType.isEmpty()) {
            assetType = ASSET_TYPE_MOVIE;
        }
        String templateXMLFileName = "template_" + assetType + TEMPLATE_FILE_EXTENSION;
        String templateXMLFilePath = templateXMLDir + File.separator + templateXMLFileName;
        String mapFilePath = this.getStringValue(executionContext, "mapFilePath");
        File mapFile = new File(mapFilePath);
        String mapFileName = mapFile.getName();
        String copyFilePath = this.makeTemplateXMLFileCopy(executionContext, templateXMLFilePath, mapFileName);
        executionContext.setVariable("metadataFilePath", (Object)copyFilePath);
    }

    private String makeTemplateXMLFileCopy(ExecutionContext executionContext, String templateXMLFilePath, String contentValue) {
        String copyFilePath = null;
        String originalDir = this.getStringValue(executionContext, "originalDir");
        Document document = this.getDocument(templateXMLFilePath);
        document = this.updateContentValue(document, contentValue);
        File file = new File(templateXMLFilePath);
        String fileName = file.getName();
        String copyFileName = fileName.replace(TEMPLATE_FILE_EXTENSION, TEMPLATE_FILE_NAME_SEPARATOR + System.currentTimeMillis() + TEMPLATE_FILE_EXTENSION);
        File copyFile = new File(originalDir, copyFileName);
        copyFilePath = copyFile.getAbsolutePath();
        this.writeDocumentCopy(document, copyFilePath);
        return copyFilePath;
    }

    Document getDocument(String originalFile) {
        Document document = null;
        try {
            File file = new File(originalFile);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.parse(file);
        }
        catch (Exception e) {
            logger.error((Object)("Exception occurred getting document from original file : " + originalFile + " : " + e), (Throwable)e);
        }
        return document;
    }

    Document updateContentValue(Document document, String contentValue) {
        Document retDocument = document;
        try {
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xpath = xPathFactory.newXPath();
            Node node = (Node)xpath.evaluate("//Asset/Content/@Value", document, XPathConstants.NODE);
            node.setNodeValue(contentValue);
        }
        catch (XPathExpressionException e) {
            logger.error((Object)("Exception occurred updating content value in document : " + e), (Throwable)e);
        }
        return retDocument;
    }

    void writeDocumentCopy(Document document, String filePath) {
        System.out.println("filePath : " + filePath);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(new File(filePath));
            DOMSource source = new DOMSource(document);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            logger.error((Object)("Exception occurred writing document copy : " + e), (Throwable)e);
        }
    }

    private String getStringValue(ExecutionContext context, String variableName) {
        Object value = context.getVariable(variableName);
        return value != null ? value.toString() : null;
    }
}

