/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.saas.ingest.packages;

import java.io.File;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class GetPackageType
implements ActionHandler {
    private static final String ARCHIVE_TYPE = "ARCHIVE";
    private static final String DIRECTORY_TYPE = "DIRECTORY";
    private static final long serialVersionUID = -5064574778559123637L;
    private static final Logger logger = Logger.getLogger(GetPackageType.class);
    private String originalFileDirectory;
    private String packageType;
    private String fileName;

    public void execute(ExecutionContext executionContext) throws Exception {
        String originalFileDirectoryValue = null;
        String packageTypeValue = null;
        String fileNameValue = null;
        try {
            originalFileDirectoryValue = (String)executionContext.getVariable(this.originalFileDirectory);
            fileNameValue = (String)executionContext.getVariable(this.fileName);
            File originalFolder = new File(originalFileDirectoryValue);
            if (!originalFolder.exists()) {
                throw new Exception("File: " + originalFileDirectoryValue + " doesn't exist");
            }
            File originalFile = new File(originalFolder, fileNameValue);
            if (originalFile.exists() && originalFile.isFile()) {
                packageTypeValue = ARCHIVE_TYPE;
            } else if (originalFolder.isDirectory()) {
                packageTypeValue = DIRECTORY_TYPE;
            } else {
                throw new Exception(String.format("Folder %s doesnt have the %s file on it or isnt a directory.", originalFolder.getAbsolutePath(), fileNameValue));
            }
            executionContext.setVariable(this.packageType, (Object)packageTypeValue);
        }
        catch (Exception e) {
            String msg = "It was not possible to determine the package type of " + originalFileDirectoryValue;
            logger.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }
}

