/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.saas.qc;

import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.naming.InitialContext;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class EmailNotificationHandler
implements ActionHandler {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(EmailNotificationHandler.class);
    private static final String MAIL_SERVICE_JNDI_NAME = "java:/Mail";
    private static final String MSG_SUBJECT = "Quality Control task failed";
    private String AddressListVar;

    public void execute(ExecutionContext ctx) throws Exception {
        if (this.isEmpty(this.AddressListVar)) {
            throw new Exception("Missing required argument 'AddressListVar'");
        }
        String addressList = (String)ctx.getVariable(this.AddressListVar);
        if (this.isEmpty(addressList)) {
            throw new Exception("Address list variable '" + this.AddressListVar + "' is empty.");
        }
        try {
            InternetAddress[] recipients = InternetAddress.parse((String)addressList, (boolean)false);
            if (recipients == null || recipients.length == 0) {
                return;
            }
            InitialContext context = new InitialContext();
            Session session = (Session)context.lookup(MAIL_SERVICE_JNDI_NAME);
            MimeMessage message = new MimeMessage(session);
            message.setFrom();
            message.setRecipients(MimeMessage.RecipientType.TO, (Address[])recipients);
            message.setSubject(MSG_SUBJECT);
            message.setText(this.getMessageBody());
            Transport.send((Message)message);
        }
        catch (Exception ex) {
            logger.warn((Object)("Failed to send email to " + addressList), (Throwable)ex);
        }
    }

    private String getMessageBody() {
        return MSG_SUBJECT;
    }

    private boolean isEmpty(String str) {
        return str == null || str.trim().length() < 1;
    }
}

