/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.saas.qc;

import java.io.File;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class ReportNameGeneratorHandler
implements ActionHandler {
    private static final long serialVersionUID = 1840738873745579633L;
    private static final String REPORT_EXTENSION = ".pdf";
    static Logger log = Logger.getLogger(ReportNameGeneratorHandler.class);
    private String BaseDirVar;
    private String BaseUrlVar;
    private String TitleIdVar;
    private String UncFilePathVar;
    private String ResultFilePathVar;
    private String ResultUrlVar;
    private String ProviderIdVar;
    private String AssetIdVar;

    public void execute(ExecutionContext ctx) throws Exception {
        if (this.isEmpty(this.BaseDirVar)) {
            throw new Exception("Missing required argument 'BaseDirVar'");
        }
        if (this.isEmpty(this.BaseUrlVar)) {
            throw new Exception("Missing required argument 'BaseUrlVar'");
        }
        if (this.isEmpty(this.TitleIdVar)) {
            throw new Exception("Missing required argument 'TitleIdVar'");
        }
        if (this.isEmpty(this.UncFilePathVar)) {
            throw new Exception("Missing required argument 'UncFilePathVar'");
        }
        if (this.isEmpty(this.ResultFilePathVar)) {
            throw new Exception("Missing required argument 'ResultFilePathVar'");
        }
        if (this.isEmpty(this.ResultUrlVar)) {
            throw new Exception("Missing required argument 'ResultUrlVar'");
        }
        if (this.isEmpty(this.ProviderIdVar)) {
            throw new Exception("Missing required argument 'ProviderIdVar'");
        }
        if (this.isEmpty(this.AssetIdVar)) {
            throw new Exception("Missing required argument 'AssetIdVar'");
        }
        String baseDir = (String)ctx.getVariable(this.BaseDirVar);
        String baseUrl = (String)ctx.getVariable(this.BaseUrlVar);
        String uncFilePath = (String)ctx.getVariable(this.UncFilePathVar);
        String titleId = (String)ctx.getVariable(this.TitleIdVar);
        String providerId = (String)ctx.getVariable(this.ProviderIdVar);
        String assetId = (String)ctx.getVariable(this.AssetIdVar);
        if (this.isEmpty(baseDir)) {
            throw new Exception("BaseDir is empty (variable '" + this.BaseDirVar + "')");
        }
        if (this.isEmpty(baseUrl)) {
            throw new Exception("BaseUrl is empty (variable '" + this.BaseUrlVar + "')");
        }
        if (this.isEmpty(uncFilePath)) {
            throw new Exception("UncFilePathVar is empty (variable '" + this.UncFilePathVar + "')");
        }
        if (this.isEmpty(titleId)) {
            throw new Exception("TitleIdVar is empty (variable '" + this.TitleIdVar + "')");
        }
        StringBuilder reportFileName = ReportNameGeneratorHandler.generateReportFileName(uncFilePath, titleId, providerId, assetId);
        ctx.setVariable("reportFileName", (Object)new StringBuilder(reportFileName).append(REPORT_EXTENSION).toString());
        log.info((Object)String.format("FTP report file name: %s", reportFileName));
        String filePath = this.createReportFilePath(baseDir, titleId, uncFilePath, reportFileName.toString());
        ctx.setVariable(this.ResultFilePathVar, (Object)filePath);
        ctx.setVariable("reportFilePathWithExtension", (Object)(filePath + REPORT_EXTENSION));
        log.info((Object)String.format("FilePath generated for report: %s", filePath));
        String url = this.createReportUrl(baseUrl, titleId, uncFilePath, reportFileName.toString());
        log.info((Object)String.format("URL generated for report: %s", url));
        ctx.setVariable(this.ResultUrlVar, (Object)url);
    }

    private static StringBuilder generateReportFileName(String uncFilePath, String titleId, String providerId, String assetId) {
        StringBuilder reportFileName = new StringBuilder(providerId).append("_").append(titleId).append("_").append(assetId).append("_");
        String fileName = uncFilePath.substring(uncFilePath.lastIndexOf(92) + 1);
        if (fileName.lastIndexOf(".") != -1) {
            fileName = fileName.substring(0, fileName.lastIndexOf("."));
        }
        reportFileName.append(fileName);
        reportFileName.append("_").append(System.currentTimeMillis());
        return reportFileName;
    }

    private String createReportFilePath(String baseDir, String titleId, String uncFilePath, String reportFileName) {
        StringBuilder bld = new StringBuilder();
        bld.append(baseDir);
        if (!baseDir.endsWith("/")) {
            bld.append("/");
        }
        bld.append(titleId).append("/");
        String folderPath = bld.toString();
        File file = new File(folderPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        bld.append(reportFileName);
        return bld.toString();
    }

    private String createReportUrl(String baseUrl, String titleId, String uncFilePath, String reportFileName) {
        StringBuilder bld = new StringBuilder();
        bld.append(baseUrl);
        if (!baseUrl.endsWith("/")) {
            bld.append("/");
        }
        bld.append(titleId + "/");
        bld.append(reportFileName).append(REPORT_EXTENSION);
        return bld.toString();
    }

    private boolean isEmpty(String str) {
        return str == null || str.trim().length() < 1;
    }
}

