/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.saas.watchfolder;

import com.ericsson.saas.common.ftp.SaaSFTPClient;
import com.tandbergtv.watchpoint.watchfolder.core.FileInfo;
import com.tandbergtv.watchpoint.watchfolder.core.IProcess;
import com.tandbergtv.watchpoint.watchfolder.util.Dispatcher;
import com.tandbergtv.watchpoint.watchfolder.util.WatchfolderProperties;
import com.tandbergtv.workflow.comm.HTTPDevice;
import com.tandbergtv.workflow.comm.ISource;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.MessageUIDImpl;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowPayload;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractFTPFileCreationProcess
implements IProcess {
    private static final String INCOMPLETE_SUFFIX_PROPERTY = "IncompleteSuffix";
    private static final String FILE_URL_PARAMETER = "filePath";
    private static final Logger logger = Logger.getLogger(AbstractFTPFileCreationProcess.class);
    private static final String SOURCE_URL = "SourceURL";
    private static final String THREAD_SLEEP_TIME = "ThreadSleepTime";
    private static final String MAX_COPY_WAIT_TIME = "MaxCopyWaitTime";
    private static final String MAX_NO_FILE_SIZE_INCREASE_TIME = "MaxNoFileSizeIncreaseTime";
    private static final String COMMAND_PARAMETER_PREFIX = "commandParameter.";
    private static final String MESSAGE_PARAMETER_PREFIX = "messageParameter.";
    private static final String COMMAND_NAME_PARAMETER = "command";
    private static final String MESSAGE_UID_PARAMETER = "messageUID";
    private static boolean configurationHasBeenRetrieved = false;
    private Map<String, String> parameterList;
    private static long maxCopyWaitTime;
    private static long maxNoFileSizeIncreaseTime;
    private static long threadSleepTime;

    public AbstractFTPFileCreationProcess() {
        this.retrieveConfiguration();
    }

    private void retrieveConfiguration() {
        if (configurationHasBeenRetrieved) {
            return;
        }
        try {
            maxCopyWaitTime = Long.parseLong(this.getProperty(MAX_COPY_WAIT_TIME));
            maxNoFileSizeIncreaseTime = Long.parseLong(this.getProperty(MAX_NO_FILE_SIZE_INCREASE_TIME));
            threadSleepTime = Long.parseLong(this.getProperty(THREAD_SLEEP_TIME));
            configurationHasBeenRetrieved = true;
        }
        catch (Exception e) {
            String msg = "It wasn't possible to retrieve the watchfolder configuration";
            logger.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
    }

    public AbstractFTPFileCreationProcess(Map<String, String> parameterList) {
        this();
        this.parameterList = parameterList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileCreated(FileInfo fileInfo) {
        logger.info((Object)("File created event called for: " + fileInfo.getAbsolutePath()));
        SaaSFTPClient ftpMonitor = null;
        try {
            ftpMonitor = new SaaSFTPClient(fileInfo.getAbsolutePath());
            if (!this.fileShouldBeProcessed(ftpMonitor)) {
                return;
            }
            String incompleteSuffix = this.parameterList.get(INCOMPLETE_SUFFIX_PROPERTY);
            ftpMonitor.waitForCopyCompletion(maxCopyWaitTime, maxNoFileSizeIncreaseTime, threadSleepTime, incompleteSuffix);
        }
        catch (Exception e) {
            this.handleFailure("Problem checking the ftp file", e, fileInfo);
            return;
        }
        finally {
            try {
                ftpMonitor.closeConnection();
            }
            catch (IOException e) {
                this.handleFailure("It wasn't possible to end the connection with the ftp server", e, fileInfo);
            }
        }
        this.sendMessageToWorkflow(fileInfo);
    }

    private void sendMessageToWorkflow(FileInfo fileInfo) {
        WorkflowMessage message = null;
        try {
            message = this.prepareMessage(fileInfo);
        }
        catch (Exception e) {
            this.handleFailure("It wasn't possible to prepare WPCL message", e, fileInfo);
            return;
        }
        logger.debug((Object)("Message Created is " + message.getPayload()));
        try {
            Dispatcher.send((WorkflowMessage)message);
        }
        catch (Exception e) {
            logger.error((Object)"Unable to send message to WatchPoint.", (Throwable)e);
            return;
        }
    }

    public void fileDeleted(FileInfo fileInfo) {
        logger.info((Object)("File deleted event called for: " + fileInfo.getAbsolutePath()));
    }

    public void fileUpdated(FileInfo fileInfo) {
        logger.info((Object)("File updated event called for: " + fileInfo.getAbsolutePath()));
    }

    private WorkflowMessage prepareMessage(FileInfo fileInfo) throws InvalidPropertiesFormatException, IOException {
        logger.debug((Object)String.format("prepareMessage start. FileInfo: %s", fileInfo));
        WorkflowMessage message = this.createNewMessage();
        this.addCommand(message);
        this.addParameters(message);
        URL url = new URL(fileInfo.getAbsolutePath());
        String urlWithoutUser = url.getProtocol() + "://" + url.getHost() + url.getPath();
        logger.debug((Object)String.format("FilePath: %s", urlWithoutUser));
        message.putValue(FILE_URL_PARAMETER, urlWithoutUser);
        logger.debug((Object)String.format("prepareMessage end. Message: %s", message));
        return message;
    }

    private WorkflowMessage createNewMessage() throws InvalidPropertiesFormatException, IOException {
        String uidValue = this.parameterList.get(MESSAGE_UID_PARAMETER);
        MessageUIDImpl messageUID = new MessageUIDImpl(uidValue);
        WorkflowMessage message = new WorkflowMessage((IMessageUID)messageUID, WorkflowMessage.MessageType.notification);
        message.setSource((ISource)new HTTPDevice(this.getProperty(SOURCE_URL)));
        return message;
    }

    private void addParameters(WorkflowMessage message) {
        Map<String, String> parameters = this.getMessageParameters(MESSAGE_PARAMETER_PREFIX);
        message.setPayload(new WorkflowPayload());
        for (String key : parameters.keySet()) {
            message.putValue(key, parameters.get(key));
        }
    }

    private void addCommand(WorkflowMessage message) {
        String commandName = this.parameterList.get(COMMAND_NAME_PARAMETER);
        if (commandName != null && commandName.trim().length() > 0) {
            WPCLCommand command = new WPCLCommand(commandName);
            command.setParameters(this.getMessageParameters(COMMAND_PARAMETER_PREFIX));
            message.setCommand(command);
        }
    }

    private Map<String, String> getMessageParameters(String prefix) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String key : this.parameterList.keySet()) {
            if (!key.startsWith(prefix)) continue;
            String name = key.substring(prefix.length());
            String value = this.parameterList.get(key);
            parameters.put(name, value);
        }
        return parameters;
    }

    private void handleFailure(String errorMessage, Exception exc, FileInfo fileInfo) {
        errorMessage = exc.getMessage() + ": " + errorMessage + ". file=" + fileInfo.getAbsolutePath();
        logger.error((Object)errorMessage, (Throwable)exc);
        try {
            logger.debug((Object)"Sending Failure message to Workflow");
            WorkflowMessage message = this.prepareMessage(fileInfo);
            message.setType(WorkflowMessage.MessageType.nack);
            message.putValue("error-message", errorMessage);
            Dispatcher.send((WorkflowMessage)message);
        }
        catch (Exception e) {
            logger.error((Object)"Exception while sending  Failure messsage to Workflow", (Throwable)e);
        }
    }

    private String getProperty(String propertyName) throws InvalidPropertiesFormatException, IOException {
        return WatchfolderProperties.getInstance().getProperty(propertyName);
    }

    public abstract boolean fileShouldBeProcessed(SaaSFTPClient var1) throws IOException;
}

