/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.saaj;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.axiom.attachments.ByteArrayDataSource;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.MIMEOutputUtils;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.impl.dom.soap11.SOAP11Factory;
import org.apache.axiom.soap.impl.dom.soap12.SOAP12Factory;
import org.apache.axis2.saaj.AttachmentPartImpl;
import org.apache.axis2.saaj.MimeHeadersEx;
import org.apache.axis2.saaj.SOAPEnvelopeImpl;
import org.apache.axis2.saaj.SOAPPartImpl;

public class SOAPMessageImpl
extends SOAPMessage {
    private SOAPPart soapPart;
    private Collection<AttachmentPart> attachmentParts = new ArrayList<AttachmentPart>();
    private MimeHeadersEx mimeHeaders;
    private Map props = new Hashtable();
    private boolean saveRequired;

    public SOAPMessageImpl(SOAPEnvelopeImpl soapEnvelope) {
        String contentType = null;
        if (this.mimeHeaders != null) {
            String[] contentTypes = this.mimeHeaders.getHeader("Content-Type");
            contentType = contentTypes != null ? contentTypes[0] : null;
        } else {
            this.mimeHeaders = new MimeHeadersEx();
            if (soapEnvelope.getOMFactory() instanceof SOAP11Factory) {
                contentType = "text/xml";
                this.mimeHeaders.addHeader("content-type", contentType);
            } else if (soapEnvelope.getOMFactory() instanceof SOAP12Factory) {
                contentType = "application/soap+xml";
                this.mimeHeaders.addHeader("content-type", contentType);
            }
        }
        this.setCharsetEncoding(contentType);
        this.soapPart = new SOAPPartImpl(this, soapEnvelope);
    }

    public SOAPMessageImpl(InputStream inputstream, MimeHeaders mimeHeaders) throws SOAPException {
        String[] contentTypes;
        String contentType = null;
        String tmpContentType = "";
        if (mimeHeaders != null && (contentTypes = mimeHeaders.getHeader("Content-Type")) != null && contentTypes.length > 0) {
            tmpContentType = contentTypes[0];
            contentType = tmpContentType.indexOf(";") > -1 ? tmpContentType.substring(0, tmpContentType.indexOf(";")) : tmpContentType;
        }
        this.setCharsetEncoding(tmpContentType);
        this.soapPart = contentType != null ? new SOAPPartImpl(this, inputstream, mimeHeaders) : new SOAPPartImpl(this, inputstream);
        this.mimeHeaders = mimeHeaders == null ? new MimeHeadersEx() : new MimeHeadersEx(mimeHeaders);
    }

    public String getContentDescription() {
        String[] values = this.mimeHeaders.getHeader("Content-Description");
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public void setContentDescription(String description) {
        this.mimeHeaders.setHeader("Content-Description", description);
    }

    public SOAPPart getSOAPPart() {
        return this.soapPart;
    }

    public void removeAllAttachments() {
        this.attachmentParts.clear();
    }

    public int countAttachments() {
        return this.attachmentParts.size();
    }

    public Iterator getAttachments() {
        return this.attachmentParts.iterator();
    }

    public Iterator getAttachments(MimeHeaders headers) {
        ArrayList<AttachmentPartImpl> matchingAttachmentParts = new ArrayList<AttachmentPartImpl>();
        Iterator iterator = this.getAttachments();
        while (iterator.hasNext()) {
            AttachmentPartImpl part = (AttachmentPartImpl)((Object)iterator.next());
            if (!part.matches(headers)) continue;
            matchingAttachmentParts.add(part);
        }
        return matchingAttachmentParts.iterator();
    }

    public void addAttachmentPart(AttachmentPart attachmentPart) {
        if (attachmentPart != null) {
            this.attachmentParts.add(attachmentPart);
            this.mimeHeaders.setHeader("Content-Type", "multipart/related");
        }
    }

    public AttachmentPart createAttachmentPart() {
        return new AttachmentPartImpl();
    }

    public MimeHeaders getMimeHeaders() {
        return this.mimeHeaders;
    }

    public void saveChanges() throws SOAPException {
        this.saveRequired = false;
    }

    public void setSaveRequired() {
        this.saveRequired = true;
    }

    public boolean saveRequired() {
        return this.saveRequired;
    }

    public void writeTo(OutputStream out) throws SOAPException, IOException {
        try {
            OMOutputFormat format = new OMOutputFormat();
            String enc = (String)this.getProperty("javax.xml.soap.character-set-encoding");
            format.setCharSetEncoding(enc != null ? enc : "utf-8");
            String writeXmlDecl = (String)this.getProperty("javax.xml.soap.write-xml-declaration");
            if (writeXmlDecl == null || writeXmlDecl.equals("false")) {
                format.setIgnoreXMLDeclaration(true);
            }
            SOAPEnvelope envelope = ((SOAPEnvelopeImpl)this.soapPart.getEnvelope()).getOMEnvelope();
            if (this.attachmentParts.isEmpty()) {
                envelope.serialize(out, format);
            } else {
                format.setSOAP11(((SOAPEnvelopeImpl)this.soapPart.getEnvelope()).getOMFactory() instanceof SOAP11Factory);
                LinkedHashMap<String, DataHandler> attachmentsMap = new LinkedHashMap<String, DataHandler>();
                for (AttachmentPart ap : this.attachmentParts) {
                    attachmentsMap.put(ap.getContentId(), ap.getDataHandler());
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                envelope.serialize((OutputStream)baos);
                String contentType = (format.isSOAP11() ? "text/xml" : "application/soap+xml") + "; charset=" + format.getCharSetEncoding();
                DataHandler rootDataHandler = new DataHandler((DataSource)new ByteArrayDataSource(baos.toByteArray(), contentType));
                MIMEOutputUtils.writeDataHandlerWithAttachmentsMessage((DataHandler)rootDataHandler, (String)contentType, (OutputStream)out, attachmentsMap, (OMOutputFormat)format);
            }
            this.saveChanges();
        }
        catch (Exception e) {
            throw new SOAPException((Throwable)e);
        }
    }

    public void setProperty(String property, Object value) {
        this.props.put(property, value);
    }

    public Object getProperty(String property) throws SOAPException {
        return this.props.get(property);
    }

    public AttachmentPart getAttachment(SOAPElement soapelement) throws SOAPException {
        Iterator iterator = this.getAttachments();
        while (iterator.hasNext()) {
            AttachmentPartImpl attachmentPart = (AttachmentPartImpl)((Object)iterator.next());
            String[] contentIds = attachmentPart.getMimeHeader("Content-Id");
            String reference = soapelement.getAttribute("href");
            if (!(reference != null && reference.trim().length() != 0 || (reference = soapelement.getValue()) != null && reference.trim().length() != 0)) {
                return null;
            }
            for (int a = 0; a < contentIds.length; ++a) {
                String idPart = reference.substring(reference.indexOf(":") + 1);
                idPart = "<" + idPart + ">";
                if (!idPart.equals(contentIds[a])) continue;
                return attachmentPart;
            }
            String[] contentLocations = attachmentPart.getMimeHeader("Content-Location");
            if (contentLocations == null) continue;
            for (int b = 0; b < contentLocations.length; ++b) {
                if (!reference.equals(contentLocations[b])) continue;
                return attachmentPart;
            }
        }
        return null;
    }

    public void removeAttachments(MimeHeaders headers) {
        Iterator<AttachmentPart> attachmentPartsItr;
        ArrayList<AttachmentPart> newAttachmentParts = new ArrayList<AttachmentPart>();
        Iterator<AttachmentPart> iter = attachmentPartsItr = this.attachmentParts.iterator();
        while (iter.hasNext()) {
            Iterator allMIMEHeaders;
            AttachmentPart attachmentPart = iter.next();
            Iterator iterator = allMIMEHeaders = headers.getAllHeaders();
            while (iterator.hasNext()) {
                MimeHeader mimeHeader = (MimeHeader)iterator.next();
                String[] headerValues = attachmentPart.getMimeHeader(mimeHeader.getName());
                if (headerValues.length == 0 || headerValues[0].equals(mimeHeader.getValue())) continue;
                newAttachmentParts.add(attachmentPart);
            }
        }
        this.attachmentParts.clear();
        this.attachmentParts = newAttachmentParts;
    }

    public SOAPHeader getSOAPHeader() throws SOAPException {
        return this.soapPart.getEnvelope().getHeader();
    }

    public SOAPBody getSOAPBody() throws SOAPException {
        return this.soapPart.getEnvelope().getBody();
    }

    private void setCharsetEncoding(String contentType) {
        int delimiterIndex;
        if (contentType != null && (delimiterIndex = contentType.lastIndexOf("charset")) > 0) {
            int index;
            int charsetIndex;
            String charsetPart = contentType.substring(delimiterIndex);
            String charset = charsetPart.substring((charsetIndex = charsetPart.indexOf(61)) + 1).trim();
            if (charset.startsWith("\"") || charset.startsWith("'")) {
                charset = charset.substring(1, charset.length());
            }
            if (charset.endsWith("\"") || charset.endsWith("'")) {
                charset = charset.substring(0, charset.length() - 1);
            }
            if ((index = charset.indexOf(59)) != -1) {
                charset = charset.substring(0, index);
            }
            this.setProperty("javax.xml.soap.character-set-encoding", charset);
        }
    }
}

