/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.util;

import java.io.IOException;
import org.apache.axis2.jaxws.catalog.JAXWSCatalogManager;
import org.apache.axis2.jaxws.description.impl.URIResolverImpl;
import org.apache.axis2.jaxws.util.CatalogWSDLLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.resolver.Catalog;
import org.xml.sax.InputSource;

public class CatalogURIResolver
extends URIResolverImpl {
    private static Log log = LogFactory.getLog(CatalogWSDLLocator.class);
    private Catalog catalogResolver;

    public CatalogURIResolver(JAXWSCatalogManager catalogManager) {
        this(catalogManager, null);
    }

    public CatalogURIResolver(JAXWSCatalogManager catalogManager, ClassLoader classLoader) {
        super(classLoader);
        if (catalogManager != null) {
            this.catalogResolver = catalogManager.getCatalog();
        }
    }

    public String getRedirectedURI(String namespace, String schemaLocation, String baseUri) {
        String resolvedImportLocation = null;
        try {
            resolvedImportLocation = this.catalogResolver.resolveSystem(namespace);
            if (resolvedImportLocation == null) {
                resolvedImportLocation = this.catalogResolver.resolveURI(schemaLocation);
            }
            if (resolvedImportLocation == null) {
                resolvedImportLocation = this.catalogResolver.resolvePublic(namespace, namespace);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Catalog resolution failed", e);
        }
        return resolvedImportLocation;
    }

    public InputSource resolveEntity(String namespace, String schemaLocation, String baseUri) {
        String redirectedURI;
        String location = schemaLocation;
        if (this.catalogResolver != null && (redirectedURI = this.getRedirectedURI(namespace, schemaLocation, baseUri)) != null) {
            location = redirectedURI;
        }
        return super.resolveEntity(namespace, location, baseUri);
    }
}

