/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.collections.AST;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;
import java.util.List;

final class RightParenthesisPrinter
extends AbstractPrinter {
    private static final RightParenthesisPrinter INSTANCE = new RightParenthesisPrinter();

    private RightParenthesisPrinter() {
    }

    public static RightParenthesisPrinter getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        if (out.mode == 1 && AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP_PAREN_GROUPING, false)) {
            List parentheses = out.state.parentheses;
            int i = 0;
            int size = parentheses.size();
            while (i < size) {
                Object parenthesis = parentheses.get(i);
                if (parenthesis == node) {
                    out.printNewline();
                    if (AbstractPrinter.settings.getBoolean(ConventionKeys.INDENT_DEEP, false)) {
                        out.state.markers.remove(out.state.markers.getLast());
                    } else {
                        out.unindent();
                    }
                    this.printIndentation(out);
                    parentheses.remove(i);
                    break;
                }
                ++i;
            }
        }
        this.printCommentsBefore(node, false, out);
        if (AbstractPrinter.settings.getBoolean(ConventionKeys.PADDING_PAREN, false)) {
            out.print(" )", 109);
        } else {
            out.print(")", 109);
        }
        this.printCommentsAfter(node, false, false, out);
    }
}

