/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.adi;

import com.tandbergtv.amsadi.AMSADIManager;
import com.tandbergtv.amsadi.ProvisionProfile;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.adaptor.dispatcher.AbstractDispatcher;
import com.tandbergtv.workflow.adaptor.dispatcher.DispatcherException;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.comm.TCPDevice;
import com.tandbergtv.workflow.device.adi.InternetHost;
import com.tandbergtv.workflow.device.adi.WPCLConverter;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IPayload;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.StringPayload;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.net.Inet4Address;
import java.net.InetAddress;
import org.apache.log4j.Logger;

public abstract class AbstractProvision
extends AbstractDispatcher {
    private static final Logger logger = Logger.getLogger(AbstractProvision.class);

    public AbstractProvision() {
    }

    public AbstractProvision(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    public IMessage send(IMessage request) throws DispatcherException {
        MessageImpl response = new MessageImpl((IPayload)new StringPayload());
        WPCLConverter converter = new WPCLConverter();
        WorkflowMessage message = null;
        try {
            message = converter.convert(request);
            ProvisionProfile profile = this.createProfile(message);
            AMSADIManager manager = new AMSADIManager(profile);
            logger.debug((Object)("Making provision call for " + message.getValue("dir")));
            manager.provisionPackage();
            message.getPayload().remove("dir");
            message.setType(WorkflowMessage.MessageType.ack);
            response = converter.convert(message);
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to provision package", e);
            message.putValue("error-message", e.getMessage());
            message.setType(WorkflowMessage.MessageType.nack);
            try {
                response = converter.convert(message);
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        return response;
    }

    protected ProvisionProfile createProfile(WorkflowMessage message) {
        ProvisionProfile profile = new ProvisionProfile();
        profile.setAdiVersion(this.getPropertyValue("isaversion"));
        profile.setAdiVODSpecVersion(this.getPropertyValue("vodspecification"));
        String hostaddress = this.getPropertyValue("ftphost");
        if (hostaddress == null) {
            Inet4Address address = InternetHost.newInstance().getHostAddress();
            if (address == null) {
                throw new RuntimeException("No IP address found");
            }
            hostaddress = ((InetAddress)address).getHostAddress();
        }
        profile.setFtpServerIP(hostaddress);
        profile.setFtpUsername(this.getPropertyValue("ftpuser"));
        profile.setFtpPassword(this.getPropertyValue("ftppassword"));
        TCPDevice device = (TCPDevice)this.getDestination();
        profile.setAmsPort(Integer.toString(device.getPort()));
        profile.setAmsServerIP(device.getIP());
        profile.setPackagedir(message.getValue("dir"));
        return profile;
    }

    protected String getPropertyValue(String property) {
        return this.getConfiguration().getParameterValue(property);
    }
}

