/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.adi;

import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.adaptor.dispatcher.AbstractDispatcher;
import com.tandbergtv.workflow.adaptor.dispatcher.DispatcherException;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.comm.TCPDevice;
import com.tandbergtv.workflow.device.adi.ISAUtil;
import com.tandbergtv.workflow.device.adi.WPCLConverter;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IPayload;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.StringPayload;
import com.tandbergtv.workflow.message.WorkflowMessage;
import org.apache.log4j.Logger;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public class Heartbeat
extends AbstractDispatcher {
    private static final Logger logger = Logger.getLogger(Heartbeat.class);

    public Heartbeat() {
    }

    public Heartbeat(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMessage send(IMessage request) throws DispatcherException {
        MessageImpl response = new MessageImpl((IPayload)new StringPayload());
        TCPDevice device = (TCPDevice)this.getDestination();
        WPCLConverter converter = new WPCLConverter();
        WorkflowMessage message = null;
        String nameservice = "corbaloc::" + device.getIP() + ":" + device.getPort() + "/NameService";
        String[] args = new String[2];
        ORB orb = null;
        args[0] = "-ORBInitRef";
        args[1] = "NameService=" + nameservice;
        try {
            message = converter.convert(request);
            orb = ISAUtil.orb_main(args);
            if (orb == null) {
                throw new RuntimeException("Could not create ORB");
            }
            logger.debug((java.lang.Object)("ORB implementation: " + orb.getClass().getName()));
            String[] path = new String[]{"Factories", "PackageFactory"};
            Object factory = ISAUtil.getFactoryObject(orb, path);
            logger.debug((java.lang.Object)("Looking up factory " + path[1]));
            if (factory == null) {
                throw new RuntimeException("Could not get PackageFactory");
            }
            message.setType(WorkflowMessage.MessageType.ack);
            logger.debug((java.lang.Object)("Got factory " + factory.getClass().getName()));
            response = converter.convert(message);
        }
        catch (Throwable e) {
            message.putValue("error-message", e.getMessage());
            message.setType(WorkflowMessage.MessageType.nack);
            try {
                response = converter.convert(message);
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        finally {
            if (orb != null) {
                orb.shutdown(true);
                orb.destroy();
            }
        }
        return response;
    }
}

