/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.adi;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class InternetHost {
    private static final Logger logger = Logger.getLogger(InternetHost.class);

    private InternetHost() {
    }

    public static InternetHost newInstance() {
        return new InternetHost();
    }

    public Inet4Address getHostAddress() {
        try {
            InetAddress localhost = InetAddress.getByName("localhost");
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                Enumeration<InetAddress> ips = ni.getInetAddresses();
                while (ips.hasMoreElements()) {
                    InetAddress ip = ips.nextElement();
                    if (ip instanceof Inet6Address) continue;
                    logger.debug((Object)("Ethernet if " + ni.getDisplayName() + " IP " + ip.getHostAddress()));
                    if (ip.getHostAddress().equals(localhost.getHostAddress())) continue;
                    return (Inet4Address)Inet4Address.class.cast(ip);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

