/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.peer;

import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.adaptor.dispatcher.AbstractDispatcher;
import com.tandbergtv.workflow.adaptor.dispatcher.DispatcherException;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IPayload;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.StringPayload;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.WPCLConverter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.log4j.Logger;

public class Heartbeat
extends AbstractDispatcher {
    private static final Logger logger = Logger.getLogger(Heartbeat.class);

    public Heartbeat(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    public IMessage send(IMessage request) throws DispatcherException {
        MessageImpl response = new MessageImpl((IPayload)new StringPayload());
        WPCLConverter converter = new WPCLConverter();
        WorkflowMessage message = null;
        try {
            message = converter.convert(request);
            URL url = new URL(this.getDestination().toString());
            String host = url.getHost();
            if (!this.isLocal(host)) {
                URLConnection connection = url.openConnection();
                connection.setConnectTimeout(30000);
                this.readFromStream(connection.getInputStream());
            }
            message.setType(WorkflowMessage.MessageType.ack);
            response = converter.convert(message);
        }
        catch (Exception e) {
            message.setType(WorkflowMessage.MessageType.nack);
            message.putValue("error-message", e.getMessage());
            try {
                response = converter.convert(message);
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        return response;
    }

    private boolean isLocal(String host) throws UnknownHostException {
        InetAddress addr = InetAddress.getByName(host);
        logger.debug((Object)("IP of peer " + addr.getHostAddress()));
        return this.getHostAddresses().contains(addr.getHostAddress());
    }

    private List<String> getHostAddresses() {
        ArrayList<String> addresses = new ArrayList<String>();
        try {
            InetAddress localhost = InetAddress.getByName("localhost");
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                Enumeration<InetAddress> ips = ni.getInetAddresses();
                while (ips.hasMoreElements()) {
                    InetAddress ip = ips.nextElement();
                    if (ip instanceof Inet6Address) continue;
                    logger.debug((Object)("Ethernet if " + ni.getDisplayName() + " IP " + ip.getHostAddress()));
                    if (ip.getHostAddress().equals(localhost.getHostAddress())) continue;
                    addresses.add(ip.getHostAddress());
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return addresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readFromStream(InputStream stream) throws IOException {
        StringBuilder buf = new StringBuilder();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(stream));
            String line = null;
            boolean firstLine = true;
            while ((line = reader.readLine()) != null) {
                if (firstLine) {
                    firstLine = false;
                } else {
                    buf.append(System.getProperty("line.separator"));
                }
                buf.append(line);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return buf.toString();
    }
}

