/*
 * Decompiled with CFR 0.152.
 */
package ca.digitalrapids.klamathserver;

import ca.digitalrapids.klamathserver.KlamathListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KlamathNative {
    public static final int STATE_IDLE = 0;
    public static final int STATE_ENCODING = 1;
    public static final int STATE_ALIVE = 2;
    public static final int STATE_NEXT_PASS = 4;

    public static native boolean IsAppLaunched(int var0);

    public static native boolean IsAppResponding(int var0);

    public static native boolean IsAppEncoding(int var0);

    public static native int GetAppState(int var0);

    public static native boolean NukeApp(int var0);

    public static boolean ExitApp(int iInstance) {
        return KlamathNative.NukeApp(iInstance);
    }

    public static Map<String, String> getTags(int instance, Map<String, String> tags) {
        String strTags;
        if (tags == null) {
            tags = new TreeMap<String, String>();
        }
        if ((strTags = KlamathNative.GetTagList(instance)) != null && strTags.length() > 0) {
            String[] tagKeys;
            for (String tag : tagKeys = strTags.split("\\n")) {
                String value = KlamathNative.GetTag(instance, tag);
                if (value == null) continue;
                tags.put(tag, value);
            }
        }
        return tags;
    }

    public static native String GetTagList(int var0);

    public static native String GetTag(int var0, String var1);

    public static native String GetAppAbout(int var0);

    public static native String GetAppTitle(int var0);

    public static native int GetAppCurrentVideoTimestamp(int var0);

    public static native int GetAppCurrentAudioTimestamp(int var0);

    public static native boolean SetCommandTimeout(int var0, int var1);

    public static native int GetCommandTimeout(int var0);

    @Deprecated
    public static native boolean IsProfileEncoding(int var0, int var1);

    public static native boolean IsProfileEncoding(int var0, String var1);

    @Deprecated
    public static native String GetProfileErrorString(int var0, int var1);

    public static native String GetProfileErrorString(int var0, String var1);

    @Deprecated
    public static native String GetProfileErrorDetails(int var0, int var1);

    public static native String GetProfileErrorDetails(int var0, String var1);

    @Deprecated
    public static native boolean SetProfileAudioCodec2(int var0, int var1, String var2);

    public static native boolean SetProfileAudioCodec(int var0, String var1, String var2);

    public static native boolean SetProject(int var0, String var1);

    public static native String GetProject(int var0);

    public static native String GetProjectErrorString(int var0);

    public static native boolean StartEncoding(int var0);

    public static native boolean StartEncoding(int var0, boolean var1);

    public static native boolean StopEncoding(int var0);

    public static native boolean StopEncoding(int var0, boolean var1);

    @Deprecated
    public static native String GetStatistics(int var0, int var1);

    public static native String GetStatistics(int var0, String var1);

    public static native int GetAppCurrentDroppedFrames(int var0);

    public static native float GetAppCurrentFrameRate(int var0);

    public static native int GetAppCurrentBufferUsage(int var0);

    public static native boolean Reboot();

    public static native int GetCPUUsage();

    public static native boolean GetSourceDuration(int var0, long[] var1);

    public static native boolean StartMonitoring(int var0);

    public static native boolean StopMonitoring(int var0);

    @Deprecated
    public static native boolean ChooseProfile(int var0, int var1);

    public static native boolean ChooseProfile(int var0, String var1);

    public static native boolean getNextFrame(ByteBuffer var0);

    public static native boolean getNextBlip(ByteBuffer var0);

    public static native boolean SetBlueBalance(int var0, float var1);

    public static native boolean SetBlueGain(int var0, float var1);

    public static native boolean SetBrightness(int var0, float var1);

    public static native boolean SetChromaGain(int var0, float var1);

    public static native boolean SetContrast(int var0, float var1);

    public static native boolean SetHue(int var0, float var1);

    public static native boolean SetRedBalance(int var0, float var1);

    public static native boolean SetRedGain(int var0, float var1);

    public static native boolean SetCropping(int var0, int var1, int var2, int var3, int var4);

    public static native boolean SetBlackBorder(int var0, int var1, int var2, int var3, int var4);

    public static native boolean SetHorizontalFilter(int var0, int var1);

    public static native boolean SetVerticalFilter(int var0, int var1);

    public static native boolean SetSpatialNoiseReduction(int var0, int var1);

    public static native boolean SetTemporalNoiseReduction(int var0, float var1);

    public static native boolean SetDeinterlace(int var0, boolean var1);

    public static native void SetSoftwareScalerEnable(int var0, boolean var1);

    public static native void SetSoftwareScalerHorzFilter(int var0, int var1);

    public static native void SetSoftwareScalerVertFilter(int var0, int var1);

    public static native boolean SetGama(int var0, boolean var1, boolean var2, double var3, double var5, double var7);

    public static native boolean SetVolume(int var0, int var1, float var2);

    public static native boolean SetBass(int var0, float var1);

    public static native boolean SetTreble(int var0, float var1);

    public static native boolean SetEQ(int var0, int var1, int var2, int var3, float var4, float var5, float var6);

    public static native boolean SetDRCE(int var0, boolean var1, float var2, float var3, float var4, float var5, float var6, float var7);

    public static native boolean SetGraphicEnable(int var0, boolean var1, String var2);

    public static native boolean SetGraphicEnable(int var0, boolean var1, String var2, double var3, double var5, double var7, double var9);

    public static native boolean SetGraphicMixer(int var0, float var1);

    public static native boolean SetGraphicFadeDuration(int var0, float var1);

    public static native boolean GraphicFadeUp(int var0);

    public static native boolean GraphicFadeDown(int var0);

    public static native boolean SetAudioMonitoringMute(int var0, boolean var1);

    public static native boolean SetLiveSourceProfileFile(int var0, String var1);

    public static native boolean SetSource(int var0, String var1);

    public static native void PauseEncoding(int var0, int var1);

    public static native void ResumeEncoding(int var0, int var1);

    public static native boolean IsEncodingPaused(int var0, int var1);

    public static native void SetBlitMode(int var0, boolean var1);

    @Deprecated
    public static native boolean SetVideoEncodingPreviewEnable(int var0, int var1, boolean var2);

    public static native boolean SetVideoEncodingPreviewEnable(int var0, String var1, boolean var2);

    @Deprecated
    public static native boolean SetVideoEncodingPostviewEnable(int var0, int var1, boolean var2);

    public static native boolean SetVideoEncodingPostviewEnable(int var0, String var1, boolean var2);

    @Deprecated
    public static native boolean SetAudioEncodingPreviewEnable(int var0, int var1, boolean var2);

    public static native boolean SetAudioEncodingPreviewEnable(int var0, String var1, boolean var2);

    public static native boolean SetMpegChapterPoints(int var0, int var1, int var2, ByteBuffer var3);

    public static native boolean IsWaitingForTape(int var0);

    public static native String GetWaitingTapeName(int var0);

    public static native boolean SetTapeReady(int var0, String var1);

    public static native String GetDeckProfileErrorString(int var0, int var1, int var2);

    public static native String GetCurrentTimecode(int var0);

    public static native String GetCurrentDeckState(int var0);

    public static native int GetDeckCaptureRecord(int var0);

    public static native boolean SetVideoStandard(int var0, int var1);

    public static native boolean SetHardwareSampleRate(int var0, int var1);

    public static native boolean LockToVideoSource(int var0, boolean var1);

    public static native String GetMonitoringErrorString(int var0);

    public static native String GetLastError(int var0);

    public static native String GetLastErrorDetails(int var0);

    public static native boolean StartMonitorNative(int var0, boolean var1, boolean var2);

    public static native boolean GetAppCurrentFrameSize(int var0, Dimension var1);

    public static native int GetUtahSdiInputFormat(int var0);

    public static native String GetHardwarePropertyName(int var0, int var1);

    public static native String GetHardwarePropertyValue(int var0, String var1);

    public static native boolean SetTag(int var0, String var1, String var2);

    public static void setMonitoringBlitHwnd(int encoderInstance, Component blitSurface) {
        if (blitSurface.isLightweight()) {
            throw new RuntimeException("Lightweight surface can't be used for a blit surface");
        }
        KlamathNative.setMonitoringBlitHwndNative(encoderInstance, blitSurface);
    }

    private static native void setMonitoringBlitHwndNative(int var0, Component var1);

    @Deprecated
    public static void setVideoEncodingPreviewBlitHwnd(int encoderInstance, int profile, Component blitSurface) {
        if (blitSurface.isLightweight()) {
            throw new RuntimeException("Lightweight surface can't be used for a blit surface");
        }
        KlamathNative.setVideoEncodingPreviewBlitHwndNative(encoderInstance, profile, blitSurface);
    }

    @Deprecated
    private static native void setVideoEncodingPreviewBlitHwndNative(int var0, int var1, Component var2);

    public static void setVideoEncodingPreviewBlitHwnd(int encoderInstance, String path, Component blitSurface) {
        if (blitSurface.isLightweight()) {
            throw new RuntimeException("Lightweight surface can't be used for a blit surface");
        }
        KlamathNative.setVideoEncodingPreviewBlitHwndNative(encoderInstance, path, blitSurface);
    }

    private static native void setVideoEncodingPreviewBlitHwndNative(int var0, String var1, Component var2);

    @Deprecated
    public static void setVideoEncodingPostviewBlitHwnd(int encoderInstance, int profile, Component blitSurface) {
        if (blitSurface.isLightweight()) {
            throw new RuntimeException("Lightweight surface can't be used for a blit surface");
        }
        KlamathNative.setVideoEncodingPostviewBlitHwndNative(encoderInstance, "/Session(" + profile + ')', blitSurface);
    }

    public static void setVideoEncodingPostviewBlitHwnd(int encoderInstance, String path, Component blitSurface) {
        if (blitSurface.isLightweight()) {
            throw new RuntimeException("Lightweight surface can't be used for a blit surface");
        }
        KlamathNative.setVideoEncodingPostviewBlitHwndNative(encoderInstance, path, blitSurface);
    }

    private static native void setVideoEncodingPostviewBlitHwndNative(int var0, String var1, Component var2);

    @Deprecated
    public static native boolean setVideoAudioEncodingPreviewEnable(int var0, int var1, boolean var2);

    @Deprecated
    public static native boolean getVideoEncodingPreviewFrameSize(int var0, int var1, Dimension var2);

    public static native boolean getVideoEncodingPreviewFrameSize(int var0, String var1, Dimension var2);

    @Deprecated
    public static native boolean getVideoEncodingPostviewFrameSize(int var0, int var1, Dimension var2);

    public static native boolean getVideoEncodingPostviewFrameSize(int var0, String var1, Dimension var2);

    public static native boolean addKlamathListener(int var0, KlamathListener var1);

    public static native boolean removeKlamathListener(KlamathListener var0);

    public static native boolean PrepareEncoding(int var0);

    public static native boolean StartPreparedEncoding(int var0);

    public static native int LaunchApp(String var0);

    public static native int GetAppProcessId(int var0);

    public static void initializeLibrary(String libPath) {
        try {
            if (!GraphicsEnvironment.isHeadless()) {
                Toolkit.getDefaultToolkit();
                Runtime.getRuntime().loadLibrary("jawt");
            }
            Runtime.getRuntime().load(libPath + "KMExternal.dll");
            Runtime.getRuntime().load(libPath + "KMRemote.dll");
        }
        catch (Throwable e) {
            System.err.println("KlamathNative: unable to load libraries: " + libPath + "\n" + e);
            throw new RuntimeException(e);
        }
    }

    public KlamathNative(String sLibraryPath) {
        KlamathNative.initializeLibrary(sLibraryPath);
    }
}

