/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.handler;

import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.adaptor.handler.AbstractHandler;
import com.tandbergtv.workflow.adaptor.handler.HandlerException;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IPayload;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.StringPayload;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.WPCLConverter;
import java.io.File;

public class CreateFolder
extends AbstractHandler {
    public CreateFolder() {
    }

    public CreateFolder(IHandlerConfiguration conf) {
        super(conf);
    }

    public IMessage postProcess(IMessage arg0) throws HandlerException {
        return arg0;
    }

    public IMessage process(IMessage arg0) throws HandlerException {
        MessageImpl ret = new MessageImpl((IPayload)new StringPayload());
        WPCLConverter converter = new WPCLConverter();
        WorkflowMessage message = null;
        try {
            message = converter.convert(arg0);
            String dir = message.getValue("dir");
            message.getPayload().remove("dir");
            File file = new File(dir);
            if (file.exists()) {
                if (file.isDirectory()) {
                    message.setType(WorkflowMessage.MessageType.ack);
                } else {
                    message.putValue("error-message", "A file with the same name exists");
                    message.setType(WorkflowMessage.MessageType.nack);
                }
            } else {
                boolean created = file.mkdirs();
                if (!created) {
                    message.setType(WorkflowMessage.MessageType.nack);
                } else {
                    message.setType(WorkflowMessage.MessageType.ack);
                }
            }
            ret = converter.convert(message);
        }
        catch (Exception e) {
            message.setType(WorkflowMessage.MessageType.nack);
            message.putValue("error-message", e.getMessage());
            try {
                ret = converter.convert(message);
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        return ret;
    }
}

