/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.handler;

import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.adaptor.handler.AbstractHandler;
import com.tandbergtv.workflow.adaptor.handler.HandlerException;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.WPCLConverter;
import java.io.File;
import org.apache.commons.io.FileUtils;

public class DeleteFolder
extends AbstractHandler {
    public DeleteFolder() {
    }

    public DeleteFolder(IHandlerConfiguration conf) {
        super(conf);
    }

    public IMessage postProcess(IMessage arg0) throws HandlerException {
        return arg0;
    }

    public IMessage process(IMessage arg0) throws HandlerException {
        IMessage ret = null;
        WPCLConverter converter = new WPCLConverter();
        WorkflowMessage message = null;
        try {
            message = converter.convert(arg0);
            String dir = message.getValue("dir");
            message.getPayload().remove("dir");
            File file = new File(dir);
            if (!file.isDirectory()) {
                message.setType(WorkflowMessage.MessageType.nack);
                message.putValue("error-message", "Input is not a directory");
            } else {
                FileUtils.forceDelete((File)file);
                message.setType(WorkflowMessage.MessageType.ack);
            }
            ret = converter.convert(message);
        }
        catch (Exception e) {
            message.setType(WorkflowMessage.MessageType.nack);
            message.putValue("error-message", e.getMessage());
            try {
                ret = converter.convert(message);
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        return ret;
    }
}

