/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.handler;

import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.adaptor.handler.AbstractHandler;
import com.tandbergtv.workflow.adaptor.handler.HandlerException;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IPayload;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.StringPayload;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.WPCLConverter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

public class ZipFolder
extends AbstractHandler {
    private static final String EXTENSION = "zip";
    private static final int BUFFER = 2048;
    private static final Logger logger = Logger.getLogger(ZipFolder.class);

    public ZipFolder() {
    }

    public ZipFolder(IHandlerConfiguration conf) {
        super(conf);
    }

    public IMessage postProcess(IMessage arg0) throws HandlerException {
        return arg0;
    }

    public IMessage process(IMessage request) throws HandlerException {
        MessageImpl ret = new MessageImpl((IPayload)new StringPayload());
        WPCLConverter converter = new WPCLConverter();
        WorkflowMessage message = null;
        try {
            message = converter.convert(request);
            String path = message.getValue("path");
            String zipfile = path + "." + EXTENSION;
            message.getPayload().remove("path");
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(new File(zipfile)));
            this.zip(path, null, zos);
            zos.flush();
            zos.close();
            message.putValue(EXTENSION, zipfile);
            message.setType(WorkflowMessage.MessageType.ack);
            ret = converter.convert(message);
        }
        catch (Exception e) {
            logger.warn((Object)"Could not create zip file", (Throwable)e);
            message.setType(WorkflowMessage.MessageType.nack);
            message.putValue("error-message", e.getMessage());
            try {
                ret = converter.convert(message);
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        return ret;
    }

    protected void zip(String directory, String parent, ZipOutputStream zos) throws IOException {
        logger.debug((Object)("Zipping " + directory));
        File f = new File(directory);
        String entry = parent == null ? f.getName() + File.separator : parent + f.getName() + File.separator;
        logger.debug((Object)("Entry " + entry));
        zos.putNextEntry(new ZipEntry(entry));
        zos.closeEntry();
        String[] files = f.list();
        for (int i = 0; i < files.length; ++i) {
            File file = new File(directory, files[i]);
            if (file.isDirectory()) {
                this.zip(file.getPath(), entry, zos);
                continue;
            }
            this.addFile(file, entry, zos);
        }
    }

    protected void addFile(File file, String parent, ZipOutputStream zos) throws IOException {
        int count;
        logger.debug((Object)("Entry " + parent + file.getName()));
        zos.putNextEntry(new ZipEntry(parent + File.separator + file.getName()));
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file), 2048);
        byte[] data = new byte[2048];
        while ((count = bis.read(data, 0, 2048)) != -1) {
            zos.write(data, 0, count);
        }
        zos.closeEntry();
        bis.close();
    }
}

