/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.utils;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class N2BBDebug {
    static PrintStream out;
    static PrintStream err;
    private static int MAX_DEBUG;
    private static int CRITICAL;

    static {
        String baseName = null;
        try {
            baseName = System.getProperty("n2bb.logFname");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (baseName == null) {
            out = System.out;
            err = System.err;
        } else {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
            baseName = String.valueOf(baseName) + "-" + df.format(new Date());
            try {
                err = new PrintStream(new FileOutputStream(String.valueOf(baseName) + ".err", true), true);
            }
            catch (IOException e) {
                e.printStackTrace();
                err = System.err;
            }
            try {
                out = new PrintStream(new FileOutputStream(String.valueOf(baseName) + ".out", true), true);
            }
            catch (IOException e) {
                e.printStackTrace(err);
                out = System.out;
            }
        }
        MAX_DEBUG = 10;
        CRITICAL = 0;
    }

    public static void logStackTrace(Throwable e) {
        e.printStackTrace(err);
    }

    public static void log(int level, String mesg) {
        if (level < MAX_DEBUG) {
            out.println(String.valueOf(new Date().toString()) + ": " + mesg);
        }
    }

    public static void err(int type, String mesg) {
        if (type == CRITICAL) {
            err.println(String.valueOf(new Date().toString()) + ":CRITICAL ERROR:" + mesg);
        } else {
            err.println(String.valueOf(new Date().toString()) + ":ERROR:" + mesg);
        }
    }
}

