/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.cablelabs11.metadata;

import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.adaptor.handler.AbstractHandler;
import com.tandbergtv.workflow.adaptor.handler.HandlerException;
import com.tandbergtv.workflow.device.cablelabs11.metadata.DocumentUtility;
import com.tandbergtv.workflow.device.cablelabs11.metadata.WPCLConverter;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IPayload;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.StringPayload;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class GetContent
extends AbstractHandler {
    private static final Logger logger = Logger.getLogger(GetContent.class);

    public GetContent() {
    }

    public GetContent(IHandlerConfiguration conf) {
        super(conf);
    }

    public IMessage postProcess(IMessage arg0) throws HandlerException {
        return arg0;
    }

    public IMessage process(IMessage request) throws HandlerException {
        MessageImpl response = new MessageImpl((IPayload)new StringPayload());
        WPCLConverter converter = new WPCLConverter();
        WorkflowMessage message = null;
        try {
            message = converter.convert(request);
            String url = message.getValue("url");
            logger.debug((Object)("Metadata file " + url));
            String directory = FilenameUtils.getFullPath((String)url);
            message.getPayload().remove("url");
            String contenturl = this.getContent(url, this.getAsset());
            if (contenturl != null && contenturl.length() > 0) {
                if (this.isURL(contenturl)) {
                    message.putValue("content", contenturl);
                } else {
                    message.putValue("content", directory + contenturl);
                }
                logger.debug((Object)("URL " + message.getValue("content")));
            } else {
                message.putValue("content", "");
            }
            message.setType(WorkflowMessage.MessageType.ack);
            response = converter.convert(message);
        }
        catch (Exception e) {
            logger.error((Object)"Failed", (Throwable)e);
            message.setType(WorkflowMessage.MessageType.nack);
            message.putValue("error-message", e.getMessage());
            try {
                response = converter.convert(message);
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        return response;
    }

    private boolean isURL(String location) {
        boolean isurl = false;
        try {
            new URL(location);
            isurl = true;
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return isurl;
    }

    protected String getAsset() {
        return this.getConfiguration().getParameterValue("asset");
    }

    protected String getContent(String path, String asset) throws Exception {
        Document document = DocumentUtility.newInstance().getDocument(path);
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node node = (Node)xpath.evaluate("//AMS[@Asset_Class='" + asset + "']", document, XPathConstants.NODE);
        if (node == null) {
            return null;
        }
        Node assetNode = node.getParentNode().getParentNode();
        return (String)xpath.evaluate("Content/@Value", assetNode, XPathConstants.STRING);
    }
}

