/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.cablelabs11.metadata;

import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.adaptor.handler.AbstractHandler;
import com.tandbergtv.workflow.adaptor.handler.HandlerException;
import com.tandbergtv.workflow.device.cablelabs11.metadata.DocumentUtility;
import com.tandbergtv.workflow.device.cablelabs11.metadata.WPCLConverter;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IPayload;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.StringPayload;
import com.tandbergtv.workflow.message.WorkflowMessage;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ReadFieldValue
extends AbstractHandler {
    private static final Logger logger = Logger.getLogger(ReadFieldValue.class);

    public ReadFieldValue() {
    }

    public ReadFieldValue(IHandlerConfiguration conf) {
        super(conf);
    }

    public IMessage postProcess(IMessage arg0) throws HandlerException {
        return arg0;
    }

    public IMessage process(IMessage request) throws HandlerException {
        MessageImpl response = new MessageImpl((IPayload)new StringPayload());
        WPCLConverter converter = new WPCLConverter();
        WorkflowMessage message = null;
        try {
            message = converter.convert(request);
            String url = message.getValue("url");
            String assetClassValue = message.getValue("assetClass");
            String fieldValue = message.getValue("fieldName");
            logger.debug((Object)("Metadata file: " + url));
            logger.debug((Object)("assetClass: " + assetClassValue));
            logger.debug((Object)("fieldName: " + fieldValue));
            message.getPayload().remove("url");
            message.putValue("fieldValue", this.getValue(url, assetClassValue, fieldValue));
            message.setType(WorkflowMessage.MessageType.ack);
            response = converter.convert(message);
        }
        catch (Exception e) {
            logger.error((Object)"Failed", (Throwable)e);
            message.setType(WorkflowMessage.MessageType.nack);
            message.putValue("error-message", e.getMessage());
            try {
                response = converter.convert(message);
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        return response;
    }

    protected String getValue(String path, String asset, String field) throws Exception {
        Document document = DocumentUtility.newInstance().getDocument(path);
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node assetNode = (Node)xpath.evaluate("//AMS[@Asset_Class='" + asset + "']", document, XPathConstants.NODE);
        if (assetNode == null) {
            return null;
        }
        logger.debug((Object)("assetNode=" + assetNode.getTextContent()));
        Node metadataNode = assetNode.getParentNode();
        Element appDataNode = (Element)xpath.evaluate("//App_Data[@Name='" + field + "']", metadataNode, XPathConstants.NODE);
        if (appDataNode != null) {
            logger.debug((Object)("appData value = " + appDataNode.getAttribute("Value")));
            return appDataNode.getAttribute("Value");
        }
        logger.debug((Object)"appData value = ");
        return "";
    }
}

