/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.cablelabs11.metadata;

import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.adaptor.handler.AbstractHandler;
import com.tandbergtv.workflow.adaptor.handler.HandlerException;
import com.tandbergtv.workflow.device.cablelabs11.metadata.DocumentUtility;
import com.tandbergtv.workflow.device.cablelabs11.metadata.WPCLConverter;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IPayload;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.StringPayload;
import com.tandbergtv.workflow.message.WorkflowMessage;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SetAssetIdPrefix
extends AbstractHandler {
    private static final Logger logger = Logger.getLogger(SetAssetIdPrefix.class);

    public SetAssetIdPrefix() {
    }

    public SetAssetIdPrefix(IHandlerConfiguration conf) {
        super(conf);
    }

    public IMessage postProcess(IMessage arg0) throws HandlerException {
        return arg0;
    }

    public IMessage process(IMessage request) throws HandlerException {
        MessageImpl response = new MessageImpl((IPayload)new StringPayload());
        WPCLConverter converter = new WPCLConverter();
        WorkflowMessage message = null;
        try {
            message = converter.convert(request);
            String url = message.getValue("url");
            String prefix = message.getValue("prefix");
            logger.debug((Object)("Metadata file " + url));
            Document document = DocumentUtility.newInstance().getDocument(url);
            message.getPayload().remove("url");
            message.getPayload().remove("prefix");
            if (prefix.length() > 4) {
                message.setType(WorkflowMessage.MessageType.nack);
                message.putValue("error-message", "Prefix cannot be longer than 4 characters");
            } else {
                String id = this.generate(document, prefix);
                DocumentUtility.newInstance().write(document, url);
                message.putValue("packageAssetId", id);
                message.setType(WorkflowMessage.MessageType.ack);
            }
            response = converter.convert(message);
        }
        catch (Exception e) {
            logger.error((Object)"Failed", (Throwable)e);
            message.setType(WorkflowMessage.MessageType.nack);
            message.putValue("error-message", e.getMessage());
            try {
                response = converter.convert(message);
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        return response;
    }

    private String generate(Document document, String prefix) throws XPathExpressionException {
        String id = this.update(document, "//Metadata/AMS[@Asset_Class='package']/@Asset_ID", prefix);
        this.update(document, "//Metadata/AMS[@Asset_Class='title']/@Asset_ID", prefix);
        this.update(document, "//Metadata/AMS[@Asset_Class='movie']/@Asset_ID", prefix);
        this.update(document, "//Metadata/AMS[@Asset_Class='poster']/@Asset_ID", prefix);
        this.update(document, "//Metadata/AMS[@Asset_Class='preview']/@Asset_ID", prefix);
        this.update(document, "//Metadata/AMS[@Asset_Class='box cover']/@Asset_ID", prefix);
        return id;
    }

    protected String update(Document document, String path, String value) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node node = (Node)xpath.evaluate(path, document, XPathConstants.NODE);
        if (node == null) {
            return null;
        }
        String id = value + node.getTextContent().substring(value.length());
        node.setTextContent(id);
        return id;
    }
}

