/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.cablelabs11.metadata;

import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.adaptor.handler.AbstractHandler;
import com.tandbergtv.workflow.adaptor.handler.HandlerException;
import com.tandbergtv.workflow.device.cablelabs11.metadata.DocumentUtility;
import com.tandbergtv.workflow.device.cablelabs11.metadata.WPCLConverter;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IPayload;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.StringPayload;
import com.tandbergtv.workflow.message.WorkflowMessage;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SetProduct
extends AbstractHandler {
    private static final Logger logger = Logger.getLogger(SetProduct.class);

    public SetProduct() {
    }

    public SetProduct(IHandlerConfiguration conf) {
        super(conf);
    }

    public IMessage postProcess(IMessage arg0) throws HandlerException {
        return arg0;
    }

    public IMessage process(IMessage request) throws HandlerException {
        MessageImpl response = new MessageImpl((IPayload)new StringPayload());
        WPCLConverter converter = new WPCLConverter();
        WorkflowMessage message = null;
        try {
            message = converter.convert(request);
            String url = message.getValue("url");
            String product = message.getValue("product");
            logger.debug((Object)("Metadata file " + url));
            Document document = DocumentUtility.newInstance().getDocument(url);
            message.getPayload().remove("url");
            message.getPayload().remove("product");
            this.setProduct(document, product);
            DocumentUtility.newInstance().write(document, url);
            message.setType(WorkflowMessage.MessageType.ack);
            response = converter.convert(message);
        }
        catch (Exception e) {
            logger.error((Object)"Failed", (Throwable)e);
            message.setType(WorkflowMessage.MessageType.nack);
            message.putValue("error-message", e.getMessage());
            try {
                response = converter.convert(message);
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        return response;
    }

    private void setProduct(Document document, String product) throws XPathException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList nodes = (NodeList)xpath.evaluate("//AMS/@Product", document, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            node.setTextContent(product);
        }
    }
}

