/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.cablelabs11.metadata;

import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.adaptor.handler.AbstractHandler;
import com.tandbergtv.workflow.adaptor.handler.HandlerException;
import com.tandbergtv.workflow.device.cablelabs11.metadata.DocumentUtility;
import com.tandbergtv.workflow.device.cablelabs11.metadata.WPCLConverter;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IPayload;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.StringPayload;
import com.tandbergtv.workflow.message.WorkflowMessage;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WriteContentField
extends AbstractHandler {
    private static final Logger logger = Logger.getLogger(WriteContentField.class);
    private static final String ASSET_CLASS = "Asset_Class";
    private static final String APP_DATA_VALUE = "Value";

    public WriteContentField() {
    }

    public WriteContentField(IHandlerConfiguration conf) {
        super(conf);
    }

    public IMessage postProcess(IMessage arg0) throws HandlerException {
        return arg0;
    }

    public IMessage process(IMessage request) throws HandlerException {
        MessageImpl response = new MessageImpl((IPayload)new StringPayload());
        WPCLConverter converter = new WPCLConverter();
        WorkflowMessage message = null;
        try {
            message = converter.convert(request);
            String url = message.getValue("url");
            String name = this.getConfiguration().getParameterValue("name");
            String value = message.getValue(name);
            String assetClass = this.getConfiguration().getParameterValue("assetClass");
            Document document = DocumentUtility.newInstance().getDocument(url);
            NodeList assetNodes = (NodeList)XPathFactory.newInstance().newXPath().evaluate("//Asset/Asset", document, XPathConstants.NODESET);
            for (int i = 0; i < assetNodes.getLength(); ++i) {
                Node assetNode = assetNodes.item(i);
                Node amsNode = (Node)XPathFactory.newInstance().newXPath().evaluate("Metadata/AMS", assetNode, XPathConstants.NODE);
                if (!amsNode.getAttributes().getNamedItem(ASSET_CLASS).getTextContent().equals(assetClass)) continue;
                Node contentNode = (Node)XPathFactory.newInstance().newXPath().evaluate("Content", assetNode, XPathConstants.NODE);
                if (contentNode == null) break;
                contentNode.getAttributes().getNamedItem(APP_DATA_VALUE).setTextContent(value);
                break;
            }
            DocumentUtility.newInstance().write(document, url);
            message.getPayload().remove("url");
            message.getPayload().remove(name);
            message.setType(WorkflowMessage.MessageType.ack);
            response = converter.convert(message);
        }
        catch (Exception e) {
            logger.error((Object)"Failed", (Throwable)e);
            message.setType(WorkflowMessage.MessageType.nack);
            message.putValue("error-message", e.getMessage());
            try {
                response = converter.convert(message);
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        return response;
    }

    protected void setAttributeValue(String expression, String attribute, Node node, String value) {
        if (node != null) {
            node.getAttributes().getNamedItem(attribute).setTextContent(value);
        }
    }

    protected String getValue(String path) throws Exception {
        Document document = DocumentUtility.newInstance().getDocument(path);
        XPath xpath = XPathFactory.newInstance().newXPath();
        return (String)xpath.evaluate(this.getXPath(), document, XPathConstants.STRING);
    }

    protected String getXPath() {
        return this.getConfiguration().getParameterValue("xpath");
    }
}

