/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.cablelabs11.metadata;

import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.adaptor.handler.AbstractHandler;
import com.tandbergtv.workflow.adaptor.handler.HandlerException;
import com.tandbergtv.workflow.device.cablelabs11.metadata.WPCLConverter;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IPayload;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.StringPayload;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.io.File;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class WriteDTD
extends AbstractHandler {
    private static final Logger logger = Logger.getLogger(WriteDTD.class);

    public WriteDTD() {
    }

    public WriteDTD(IHandlerConfiguration conf) {
        super(conf);
    }

    public IMessage postProcess(IMessage arg0) throws HandlerException {
        return arg0;
    }

    public IMessage process(IMessage request) throws HandlerException {
        MessageImpl response = new MessageImpl((IPayload)new StringPayload());
        WPCLConverter converter = new WPCLConverter();
        WorkflowMessage message = null;
        try {
            message = converter.convert(request);
            String path = message.getValue("path");
            logger.debug((Object)("Copying to " + path));
            message.getPayload().remove("path");
            File destination = new File(path);
            if (!destination.exists()) {
                message.putValue("error-message", "Directory does not exist");
                message.setType(WorkflowMessage.MessageType.nack);
            } else if (!destination.isDirectory()) {
                message.putValue("error-message", "Path does not refer to a directory");
                message.setType(WorkflowMessage.MessageType.nack);
            } else {
                URL url = this.getConfiguration().getClassLoader().getResource("./ADI.DTD");
                logger.debug((Object)("URL " + url));
                File dtd = new File(url.toURI());
                FileUtils.copyFileToDirectory((File)dtd, (File)destination);
                message.setType(WorkflowMessage.MessageType.ack);
            }
            response = converter.convert(message);
        }
        catch (Exception e) {
            logger.error((Object)"Failed", (Throwable)e);
            message.setType(WorkflowMessage.MessageType.nack);
            message.putValue("error-message", e.getMessage());
            try {
                response = converter.convert(message);
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        return response;
    }
}

