/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.corba.idl.values;

import org.apache.axis2.corba.idl.types.DataType;
import org.apache.axis2.corba.idl.types.EnumType;
import org.apache.axis2.corba.idl.types.Member;
import org.apache.axis2.corba.idl.types.UnionMember;
import org.apache.axis2.corba.idl.types.UnionType;
import org.apache.axis2.corba.idl.values.AbstractValue;
import org.apache.axis2.corba.idl.values.EnumValue;
import org.apache.axis2.corba.receivers.CorbaUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public class UnionValue
extends AbstractValue {
    private static final Log log = LogFactory.getLog(UnionValue.class);
    private Object discriminator;
    private String memberName;
    private Object memberValue;
    private DataType memberType;

    public UnionValue(UnionType unionType) {
        super(unionType);
    }

    public void read(InputStream inputStream) {
        UnionType unionType = (UnionType)this.dataType;
        this.discriminator = this.read(unionType.getDiscriminatorType(), inputStream);
        this.populateValue();
        this.memberValue = this.read(this.getMemberType(), inputStream);
    }

    private void populateValue() {
        Member[] members = this.getMembers();
        UnionMember unionMember = null;
        String discriminatorStr = this.discriminator instanceof EnumValue ? ((EnumValue)this.discriminator).getValueAsString() : this.discriminator.toString();
        for (int i = 0; i < members.length && !discriminatorStr.equals((unionMember = (UnionMember)members[i]).getDiscriminatorValue()); ++i) {
        }
        if (unionMember != null) {
            this.memberName = unionMember.getName();
            this.setMemberType(unionMember.getDataType());
        } else {
            log.error((Object)"Union must have atleast one members");
        }
    }

    private void populateDiscriminator() {
        Member[] members = this.getMembers();
        UnionMember unionMember = null;
        for (int i = 0; i < members.length && !(unionMember = (UnionMember)members[i]).getName().equals(this.memberName); ++i) {
        }
        if (unionMember != null) {
            this.setMemberType(unionMember.getDataType());
            if (!unionMember.isDefault()) {
                this.discriminator = CorbaUtil.parseValue(((UnionType)this.dataType).getDiscriminatorType(), unionMember.getDiscriminatorValue());
            } else if (unionMember.isDefault()) {
                DataType discriminatorType = ((UnionType)this.dataType).getDiscriminatorType();
                int kindVal = discriminatorType.getTypeCode().kind().value();
                switch (kindVal) {
                    case 3: {
                        this.discriminator = Integer.MIN_VALUE;
                        break;
                    }
                    case 9: 
                    case 26: {
                        this.discriminator = Character.valueOf('\u0000');
                        break;
                    }
                    case 17: {
                        EnumType enumType = (EnumType)discriminatorType;
                        EnumValue enumValue = new EnumValue(enumType);
                        enumValue.setValue(0);
                        this.discriminator = enumValue;
                        break;
                    }
                    default: {
                        log.error((Object)"Unsupported union member type");
                        break;
                    }
                }
            } else {
                this.discriminator = null;
            }
        }
    }

    public void write(OutputStream outputStream) {
        this.populateDiscriminator();
        this.write(this.discriminator, ((UnionType)this.dataType).getDiscriminatorType(), outputStream);
        this.write(this.memberValue, this.getMemberType(), outputStream);
    }

    public String getMemberName() {
        return this.memberName;
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    public Object getMemberValue() {
        return this.memberValue;
    }

    public void setMemberValue(Object memberValue) {
        this.memberValue = memberValue;
    }

    public DataType getMemberType() {
        return this.memberType;
    }

    public void setMemberType(DataType memberType) {
        this.memberType = memberType;
    }
}

