/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.baton;

import com.tandbergtv.workflow.adaptor.AdaptorException;
import com.tandbergtv.workflow.adaptor.AdaptorResponseImpl;
import com.tandbergtv.workflow.adaptor.IAdaptor;
import com.tandbergtv.workflow.adaptor.IAdaptorRequest;
import com.tandbergtv.workflow.adaptor.IAdaptorResponse;
import com.tandbergtv.workflow.adaptor.conf.IAdaptorConfiguration;
import com.tandbergtv.workflow.comm.IDevice;
import com.tandbergtv.workflow.device.baton.util.WPCLConverter;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.IPayload;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.StringPayload;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.util.MarshalException;
import com.tandbergtv.workflow.message.util.Marshaller;
import com.tandbergtv.workflow.util.DeviceTypeUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcClientException;
import org.apache.xmlrpc.XmlRpcException;
import org.w3c.dom.Document;
import sun.misc.BASE64Decoder;

public class BatonAdaptor
implements IAdaptor {
    private static final Logger logger = Logger.getLogger(BatonAdaptor.class);
    private static final String EXECUTETESTPLAN = "01bv01";
    private static final String VERIFYTASKSTATUS = "01bv02";
    private static final String GETREPORT = "01bv03";
    private static final String DELETETASK = "01bv04";
    private static final String GETPROFILE = "01bv05";
    private static final String GETXMLREPORT = "01bv06";
    private static final String TESTPLANNAME = "testPlanName";
    private static final String SOURCEFILE = "sourceFile";
    private static final String METADATAREPORT = "metaDataReportFile";
    private static final String STATUS = "status";
    private static final String ERROR = "Error";
    private static final String PERCENT = "percent";
    private static final String DESCRIPTION = "description";
    private static final String REPORTFILE = "reportFile";
    private static final String TASKID = "taskId";
    public static final String TEST_PLAN_VERSION = "";
    public static final String PRIORITY = "High";
    private static final List<String> messages = Arrays.asList("01bv01", "01bv02", "01bv03", "01bv04", "01bv05", "01bv06");
    IAdaptorConfiguration conf = null;

    public void init(IAdaptorConfiguration arg0) {
        this.conf = arg0;
        logger.info((Object)"Initialized");
    }

    public IAdaptorResponse transmit(IAdaptorRequest iar) throws AdaptorException {
        WorkflowMessage message = null;
        try {
            message = new WPCLConverter().convert(iar.getMessage());
        }
        catch (Exception e) {
            throw new AdaptorException((Throwable)e);
        }
        IMessageUID messageUID = message.getMessageUID();
        logger.debug((Object)("Processing message[" + messageUID.getUID() + "] - " + messageUID.getName()));
        String url = DeviceTypeUtil.getConnectionString((IDevice)((IDevice)iar.getDestinations().get(0)));
        if (messageUID.getUID().equals(EXECUTETESTPLAN)) {
            return this.executeTestPlan(url, message);
        }
        if (messageUID.getUID().equals(VERIFYTASKSTATUS)) {
            return this.verifyTaskStatus(url, message);
        }
        if (messageUID.getUID().equals(GETREPORT)) {
            return this.getReport(url, message);
        }
        if (messageUID.getUID().equals(DELETETASK)) {
            return this.deleteTask(url, message);
        }
        if (messageUID.getUID().equals(GETPROFILE)) {
            return this.getMetadata(url, message);
        }
        if (messageUID.getUID().equals(GETXMLREPORT)) {
            return this.getReport(url, message, false);
        }
        throw new AdaptorException(messageUID + " Is unknown");
    }

    private IAdaptorResponse deleteTask(String url, WorkflowMessage message) {
        String taskId = message.getValue(TASKID);
        String errorMsg = TEST_PLAN_VERSION;
        try {
            XmlRpcClient baton = new XmlRpcClient(url);
            Vector<String> params = new Vector<String>();
            params.addElement(taskId);
            Object result = baton.execute("Baton.Tasks.deleteCompletedTasks", params);
            if (result instanceof XmlRpcException) {
                throw (XmlRpcException)result;
            }
            WorkflowMessage responseMessage = WorkflowMessageFactory.createAckMessage((WorkflowMessage)message);
            responseMessage.setSource(null);
            return this.transform(responseMessage);
        }
        catch (Exception e) {
            errorMsg = e.getMessage();
            logger.error((Object)"Got exception while deleting the task", (Throwable)e);
            WorkflowMessage responseMessage = WorkflowMessageFactory.createNackMessage((WorkflowMessage)message);
            responseMessage.setSource(null);
            responseMessage.putValue("error-message", errorMsg);
            return this.transform(responseMessage);
        }
    }

    private IAdaptorResponse getReport(String url, WorkflowMessage message) {
        return this.getReport(url, message, true);
    }

    private IAdaptorResponse getReport(String url, WorkflowMessage message, boolean PDFReport) {
        String reportFileName = message.getValue(REPORTFILE);
        String taskId = message.getValue(TASKID);
        String errorMsg = TEST_PLAN_VERSION;
        try {
            String result;
            XmlRpcClient baton = new XmlRpcClient(url);
            Vector<String> params = new Vector<String>();
            params.addElement(taskId);
            if (PDFReport) {
                result = (String)baton.execute("Baton.Tasks.reportInPDF", params);
                reportFileName = reportFileName + ".pdf";
            } else {
                result = (String)baton.execute("Baton.Tasks.report", params);
                reportFileName = reportFileName + ".xml";
            }
            if (result instanceof XmlRpcException) {
                throw (XmlRpcException)result;
            }
            String report = result;
            File file = new File(reportFileName);
            FileOutputStream fos = new FileOutputStream(file);
            if (PDFReport) {
                byte[] reportArray = BatonAdaptor.b64decode(report);
                fos.write(reportArray);
            } else {
                fos.write(report.getBytes());
            }
            fos.close();
            WorkflowMessage responseMessage = WorkflowMessageFactory.createAckMessage((WorkflowMessage)message);
            responseMessage.setSource(null);
            return this.transform(responseMessage);
        }
        catch (Exception e) {
            errorMsg = e.getMessage();
            logger.error((Object)"Got exception while writing the file", (Throwable)e);
            WorkflowMessage responseMessage = WorkflowMessageFactory.createNackMessage((WorkflowMessage)message);
            responseMessage.setSource(null);
            responseMessage.putValue("error-message", errorMsg);
            return this.transform(responseMessage);
        }
    }

    private IAdaptorResponse getMetadata(String url, WorkflowMessage message) {
        String mediaFilePath = message.getValue(SOURCEFILE);
        String metaDataReport = message.getValue(METADATAREPORT);
        String errorMsg = TEST_PLAN_VERSION;
        try {
            XmlRpcClient baton = new XmlRpcClient(url);
            Vector<String> params = new Vector<String>();
            params.addElement(mediaFilePath);
            String profilerId = (String)baton.execute("Baton.Profiles.profileFile", params);
            params.clear();
            params.addElement(profilerId);
            String result = (String)baton.execute("Baton.Profiles.getProfile", params);
            if (result instanceof XmlRpcException) {
                throw (XmlRpcException)result;
            }
            String report = result;
            File file = new File(metaDataReport + ".xml");
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(report.getBytes());
            fos.close();
            WorkflowMessage responseMessage = WorkflowMessageFactory.createAckMessage((WorkflowMessage)message);
            responseMessage.setSource(null);
            return this.transform(responseMessage);
        }
        catch (Exception e) {
            errorMsg = e.getMessage();
            logger.error((Object)"Got exception while getting metadata file", (Throwable)e);
            WorkflowMessage responseMessage = WorkflowMessageFactory.createNackMessage((WorkflowMessage)message);
            responseMessage.setSource(null);
            responseMessage.putValue("error-message", errorMsg);
            return this.transform(responseMessage);
        }
    }

    private IAdaptorResponse verifyTaskStatus(String url, WorkflowMessage message) {
        String taskId = message.getValue(TASKID);
        WorkflowMessage responseMessage = WorkflowMessageFactory.createAckMessage((WorkflowMessage)message);
        String errorMsg = TEST_PLAN_VERSION;
        try {
            Vector<String> params = new Vector<String>();
            params.addElement(taskId);
            XmlRpcClient baton = new XmlRpcClient(url);
            String percent = Integer.toString((Integer)baton.execute("Baton.Tasks.progress", params));
            logger.debug((Object)("Task status percent:" + percent));
            Object result = baton.execute("Baton.Tasks.result", params);
            if (result instanceof XmlRpcException) {
                throw (XmlRpcException)((Object)result);
            }
            List results = (List)result;
            String status = (String)results.get(0);
            logger.debug((Object)("Task Result status:" + status));
            String description = (String)results.get(1);
            logger.debug((Object)("Task Result description:" + description));
            if (status.equalsIgnoreCase("success") || status.equalsIgnoreCase("Incomplete")) {
                responseMessage.setType(WorkflowMessage.MessageType.ack);
            } else if (status.equalsIgnoreCase("failure") || status.equalsIgnoreCase("warnings") || status.equalsIgnoreCase("aborted") || status.equalsIgnoreCase("unknown") || status.equalsIgnoreCase("Partial")) {
                responseMessage.setType(WorkflowMessage.MessageType.nack);
                responseMessage.putValue("error-message", description);
            }
            WPCLCommand command = new WPCLCommand("task-update");
            command.addParameter(PERCENT, percent);
            responseMessage.setCommand(command);
            responseMessage.putValue(STATUS, status);
            responseMessage.putValue(DESCRIPTION, description);
            responseMessage.setSource(null);
            return this.transform(responseMessage);
        }
        catch (XmlRpcClientException e) {
            errorMsg = e.getMessage();
            logger.error((Object)"Problem with XMLRPC method call from client side.", (Throwable)e);
        }
        catch (MalformedURLException e) {
            errorMsg = e.getMessage();
            logger.error((Object)"URL of BATON Application is invalid.", (Throwable)e);
        }
        catch (XmlRpcException e) {
            errorMsg = e.getMessage();
            logger.error((Object)"Problem with XMLRPC method call from client side.", (Throwable)e);
        }
        catch (IOException e) {
            errorMsg = e.getMessage();
            logger.error((Object)"IO Problem", (Throwable)e);
        }
        catch (Exception e) {
            errorMsg = e.getMessage();
            logger.error((Object)"Unable to handle message", (Throwable)e);
        }
        responseMessage.setType(WorkflowMessage.MessageType.nack);
        responseMessage.putValue(STATUS, ERROR);
        responseMessage.putValue("error-message", errorMsg);
        responseMessage.setSource(null);
        return this.transform(responseMessage);
    }

    private IAdaptorResponse transform(WorkflowMessage responseMessage) {
        Marshaller m = Marshaller.newMarshaller();
        StringWriter sw = new StringWriter();
        try {
            Document responseDoc = m.marshal(responseMessage);
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.transform(new DOMSource(responseDoc.getDocumentElement()), new StreamResult(sw));
        }
        catch (MarshalException e) {
            logger.error((Object)e);
        }
        catch (TransformerException e) {
            logger.error((Object)e);
        }
        catch (TransformerFactoryConfigurationError e) {
            logger.error((Object)e);
        }
        MessageImpl iMessage = new MessageImpl((IPayload)new StringPayload(sw.getBuffer().toString()));
        return new AdaptorResponseImpl((IMessage)iMessage);
    }

    public void destroy() {
    }

    public boolean canDeliver(IAdaptorRequest arg0) {
        try {
            WPCLConverter converter = new WPCLConverter();
            WorkflowMessage wfsMessage = converter.convert(arg0.getMessage());
            if (messages.contains(wfsMessage.getMessageUID().getUID())) {
                return true;
            }
        }
        catch (Exception ex) {
            logger.warn((Object)("Unable to handle message " + arg0.getMessage().getPayload().getContent()), (Throwable)ex);
        }
        return false;
    }

    private IAdaptorResponse executeTestPlan(String url, WorkflowMessage message) {
        String testPlan = message.getValue(TESTPLANNAME);
        String srcFile = message.getValue(SOURCEFILE);
        String description = TEST_PLAN_VERSION;
        String mediaFilePath = TEST_PLAN_VERSION;
        String errorMsg = TEST_PLAN_VERSION;
        try {
            XmlRpcClient baton = new XmlRpcClient(url);
            Vector<String> location = new Vector<String>();
            if (srcFile.toUpperCase().contains("FTP:")) {
                mediaFilePath = srcFile;
                int indexOfDoubleSlash = srcFile.indexOf("//");
                int indexOfAtSign = srcFile.indexOf("@");
                String userName = TEST_PLAN_VERSION;
                String passWord = TEST_PLAN_VERSION;
                String hostAndPort = srcFile.substring(indexOfDoubleSlash + 2);
                if (indexOfAtSign != -1) {
                    String nameAndPAssword = srcFile.substring(indexOfDoubleSlash + 2, indexOfAtSign);
                    int indexOfColon = nameAndPAssword.indexOf(":");
                    userName = nameAndPAssword.substring(0, indexOfColon);
                    passWord = indexOfColon != -1 ? nameAndPAssword.substring(indexOfColon + 1) : (passWord = TEST_PLAN_VERSION);
                    hostAndPort = srcFile.substring(indexOfAtSign + 1);
                }
                int indexOfPort = hostAndPort.indexOf(":");
                int endIndexOfPort = hostAndPort.indexOf("/");
                String ipAddress = hostAndPort.substring(0, indexOfPort - 1);
                String port = hostAndPort.substring(indexOfPort + 1, endIndexOfPort - 1);
                Vector<String> ftpParams = new Vector<String>();
                ftpParams.addElement(ipAddress);
                ftpParams.addElement(port);
                ftpParams.addElement(userName);
                ftpParams.addElement(passWord);
                baton.execute("Baton.Setup.ContentLocations.registerFTPLocation", ftpParams);
            } else if (srcFile.contains("\\")) {
                String pathOfUNCFolder;
                int indexOfColon = srcFile.indexOf(":");
                int indexOfDoubleSlash = srcFile.indexOf("\\");
                mediaFilePath = pathOfUNCFolder = srcFile.substring(indexOfDoubleSlash);
                String userName = TEST_PLAN_VERSION;
                String passWord = TEST_PLAN_VERSION;
                if (indexOfColon != -1) {
                    userName = srcFile.substring(0, indexOfColon - 1);
                    passWord = srcFile.substring(indexOfColon + 1, indexOfDoubleSlash - 1);
                }
                Vector<String> uncParameters = new Vector<String>();
                uncParameters.addElement(pathOfUNCFolder);
                uncParameters.addElement(userName);
                uncParameters.addElement(passWord);
                baton.execute("Baton.Setup.ContentLocations.registerUNCLocation", uncParameters);
            } else {
                File mediaFile = new File(srcFile);
                mediaFilePath = mediaFile.toString();
                location.addElement(mediaFile.getAbsolutePath());
                baton.execute("Baton.Setup.ContentLocations.registerFSLocation", location);
            }
            Vector<String> verifyFileParams = new Vector<String>();
            verifyFileParams.addElement(testPlan);
            verifyFileParams.addElement(TEST_PLAN_VERSION);
            verifyFileParams.addElement(PRIORITY);
            verifyFileParams.addElement(mediaFilePath.toString());
            Object result = baton.execute("Baton.Tasks.verifyFile", verifyFileParams);
            if (result instanceof XmlRpcException) {
                throw (XmlRpcException)((Object)result);
            }
            String taskId = (String)result;
            logger.debug((Object)("Task Id: " + taskId));
            WorkflowMessage responseMessage = WorkflowMessageFactory.createAckMessage((WorkflowMessage)message);
            responseMessage.putValue(TASKID, taskId);
            responseMessage.setSource(null);
            return this.transform(responseMessage);
        }
        catch (MalformedURLException e) {
            errorMsg = e.getMessage();
            logger.error((Object)"URL of BATON Application is invalid.", (Throwable)e);
        }
        catch (XmlRpcClientException e) {
            errorMsg = e.getMessage();
            logger.error((Object)"Problem with XMLRPC method call from client side.", (Throwable)e);
        }
        catch (IOException e) {
            errorMsg = e.getMessage();
            logger.error((Object)"Couldn't connect to Baton XMLRPC Server.", (Throwable)e);
        }
        catch (XmlRpcException e) {
            errorMsg = e.getMessage();
            logger.error((Object)"Problem with XMLRPC method call.", (Throwable)e);
            description = e.getMessage();
        }
        WorkflowMessage responseMessage = WorkflowMessageFactory.createNackMessage((WorkflowMessage)message);
        responseMessage.putValue(STATUS, ERROR);
        responseMessage.putValue(DESCRIPTION, description);
        responseMessage.putValue("error-message", errorMsg);
        responseMessage.setSource(null);
        return this.transform(responseMessage);
    }

    private static final byte[] b64decode(String data) {
        try {
            BASE64Decoder dec = new BASE64Decoder();
            byte[] bytes = dec.decodeBuffer(data.trim());
            return bytes;
        }
        catch (IOException e) {
            System.out.println("Exception caught when base64 decoding!" + e.toString());
            return null;
        }
    }
}

