/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.baton;

import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.AbstractHeartBeatStrategy;
import com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.ResourceHeartBeatEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcClientException;
import org.apache.xmlrpc.XmlRpcException;

public class BatonAdaptorHBS
extends AbstractHeartBeatStrategy
implements Runnable {
    private static final Logger logger = Logger.getLogger(BatonAdaptorHBS.class);
    private String userName;
    private String password;

    protected Runnable getHeartBeatCommand() {
        return this;
    }

    @Override
    public void run() {
        Resource hbResource = this.getResource();
        String connectionString = hbResource.getHeartbeatConnectionString();
        String name = "" + hbResource.getId() + " " + hbResource.getName();
        logger.debug((Object)("BatonAdaptortHBS.run... HB for " + name + " is Successful"));
        try {
            XmlRpcClient baton = new XmlRpcClient(connectionString);
            Vector params = new Vector();
            Object result = baton.execute("Baton.majorVersion", params);
            String errorMessage = "Baton not available";
            if (result == null) {
                this.fireHeartBeatFailureEvent(this.createEvent(errorMessage));
            }
            if (result instanceof XmlRpcException || result instanceof XmlRpcClientException || result instanceof MalformedURLException || result instanceof IOException) {
                Exception ex = (Exception)result;
                errorMessage = errorMessage + ex.getLocalizedMessage();
                logger.error((Object)("Baton not availanle - " + errorMessage));
                this.fireHeartBeatFailureEvent(this.createEvent(errorMessage));
            }
            this.fireHeartBeatSuccessEvent(this.createEvent("HB for " + name + "is Successful"));
        }
        catch (XmlRpcClientException e) {
            logger.error((Object)"Problem with XMLRPC method call from client side.", (Throwable)e);
            this.fireHeartBeatFailureEvent(this.createEvent("Baton not available -" + e.getLocalizedMessage()));
        }
        catch (MalformedURLException e) {
            logger.error((Object)"URL of BATON Application is invalid.", (Throwable)e);
            this.fireHeartBeatFailureEvent(this.createEvent("Baton not available -" + e.getLocalizedMessage()));
        }
        catch (XmlRpcException e) {
            logger.error((Object)"Problem with XMLRPC method call from client side.", (Throwable)e);
            this.fireHeartBeatFailureEvent(this.createEvent("Baton not available - " + e.getLocalizedMessage()));
        }
        catch (IOException e) {
            logger.error((Object)"IO Problem", (Throwable)e);
            this.fireHeartBeatFailureEvent(this.createEvent("Baton not available - " + e.getLocalizedMessage()));
        }
        catch (Exception e) {
            logger.error((Object)"Catched exception in the Baton HB ", (Throwable)e);
            this.fireHeartBeatFailureEvent(this.createEvent("Baton not available - " + e.getLocalizedMessage()));
        }
    }

    private ResourceHeartBeatEvent createEvent(String msg) {
        ResourceHeartBeatEvent event = new ResourceHeartBeatEvent((Object)this, this.getResource(), msg);
        return event;
    }
}

