/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.digitalRapids;

import ca.digitalrapids.klamathserver.Stream;
import ca.digitalrapids.klamathserver.StreamService;
import com.tandbergtv.workflow.adaptor.AdaptorException;
import com.tandbergtv.workflow.adaptor.AdaptorResponseImpl;
import com.tandbergtv.workflow.adaptor.IAdaptor;
import com.tandbergtv.workflow.adaptor.IAdaptorRequest;
import com.tandbergtv.workflow.adaptor.IAdaptorResponse;
import com.tandbergtv.workflow.adaptor.conf.IAdaptorConfiguration;
import com.tandbergtv.workflow.comm.IDevice;
import com.tandbergtv.workflow.device.digitalRapids.WPCLConverter;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.IPayload;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.StringPayload;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.util.MarshalException;
import com.tandbergtv.workflow.message.util.Marshaller;
import com.tandbergtv.workflow.util.DeviceTypeUtil;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class DigitalRapidsAdaptor
implements IAdaptor {
    private static final Logger logger = Logger.getLogger(DigitalRapidsAdaptor.class);
    private static final String LAUNCHJOB = "01dr01";
    private static final String GETSTATUS = "01dr02";
    private static final String PROJECTNAME = "projectname";
    private static final String INSTANCEID = "instance";
    private static final String STATUS = "Status";
    private static final String STATUSASSTRING = "Status as String";
    private static final String ERROR_MESSAGE = "error-message";
    private static final String RESULT = "result";
    private static final String INFO = "Info";
    private static final String INPUTFILENAME = "inputfilename";
    private static final List<String> messages = Arrays.asList("01dr01", "01dr02");
    private static final String STATE_ALIVE = "Not currently encoding, but an encode is still alive.";
    private static final String STATE_ENCODING = "Application is encoding";
    private static final String STATE_IDLE = "Encoder isn't busy";
    private static final String STATE_UNDEF = "State not define";
    private static final String STATE_NEXT_PASS = "Not currently encoding, but an encode is still alive";
    private static final List<String> DigitalRapidsState = Arrays.asList("Encoder isn't busy", "Application is encoding", "Not currently encoding, but an encode is still alive.", "State not define", "Not currently encoding, but an encode is still alive");
    IAdaptorConfiguration conf = null;

    public boolean canDeliver(IAdaptorRequest arg0) {
        try {
            WPCLConverter converter = new WPCLConverter();
            WorkflowMessage wfsMessage = converter.convert(arg0.getMessage());
            if (messages.contains(wfsMessage.getMessageUID().getUID())) {
                return true;
            }
        }
        catch (Exception ex) {
            logger.warn((Object)("Unable to handle message " + arg0.getMessage().getPayload().getContent()), (Throwable)ex);
        }
        return false;
    }

    public void init(IAdaptorConfiguration arg0) {
        this.conf = arg0;
        logger.info((Object)"Initialized");
    }

    public IAdaptorResponse transmit(IAdaptorRequest iar) throws AdaptorException {
        IAdaptorResponse response = null;
        WorkflowMessage message = null;
        try {
            message = new WPCLConverter().convert(iar.getMessage());
        }
        catch (Exception e) {
            throw new AdaptorException((Throwable)e);
        }
        IMessageUID messageUID = message.getMessageUID();
        logger.debug((Object)("Processing message[" + messageUID.getUID() + "] - " + messageUID.getName()));
        String url = DeviceTypeUtil.getConnectionString((IDevice)((IDevice)iar.getDestinations().get(0)));
        if (messageUID.getUID().equals(LAUNCHJOB)) {
            response = this.launchjob(message, url);
        } else if (messageUID.getUID().equals(GETSTATUS)) {
            response = this.getStatus(message, url);
        }
        return response;
    }

    private IAdaptorResponse getStatus(WorkflowMessage message, String url) {
        StringBuilder encodeSucess;
        StreamService service;
        int state = -1;
        int instance = Integer.parseInt(message.getValue(INSTANCEID));
        try {
            service = new StreamService(new URL(url));
        }
        catch (MalformedURLException e) {
            return this.processException(e, message);
        }
        Stream stream = service.getStreamPort();
        state = stream.getAppState(instance);
        int seconds = stream.getAppCurrentVideoTimestamp(instance);
        boolean encodedOK = true;
        int profiles = stream.getNumberOfProfiles(instance);
        StringBuilder encodeFailedMsg = new StringBuilder("Encode Failed:");
        for (int i = 0; i < profiles; ++i) {
            String profErr = stream.getProfileErrorString(instance, "/Session(" + i + ")");
            if (profErr.length() <= 0) continue;
            encodeFailedMsg.append("\n" + profErr);
            encodedOK = false;
        }
        String lastError = stream.getLastError(instance);
        if (lastError.length() > 0) {
            encodedOK = false;
            encodeFailedMsg.append(lastError);
        }
        if (encodedOK) {
            encodeSucess = state == 0 ? new StringBuilder("Encode succeeded; Output filename(s):") : new StringBuilder("Encoding in progress; Output filename(s):");
            for (int i = 0; i < profiles; ++i) {
                String file = stream.getTag(instance, "PROF." + i + ".ARCHIVE.FILENAME");
                if (file == null || file.length() <= 0) continue;
                encodeSucess.append("" + file);
            }
        } else {
            return this.handleError(message, encodeFailedMsg.toString());
        }
        encodeSucess.append(" Encoded " + seconds + " seconds of video. " + " Dropped " + stream.getAppCurrentDroppedFrames(instance) + " frames");
        WPCLCommand command = state == 0 ? new WPCLCommand("task-complete") : new WPCLCommand("task-update");
        WorkflowMessage responseMessage = WorkflowMessageFactory.createAckMessage((WorkflowMessage)message);
        responseMessage.setCommand(command);
        responseMessage.putValue(STATUS, String.valueOf(state));
        responseMessage.putValue(STATUSASSTRING, DigitalRapidsState.get(state));
        responseMessage.putValue(RESULT, command.getName());
        responseMessage.putValue(INFO, encodeSucess.toString());
        responseMessage.setSource(null);
        return this.transform(responseMessage);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IAdaptorResponse launchjob(WorkflowMessage message, String url) {
        StreamService service;
        String project = message.getValue(PROJECTNAME);
        String inputFilename = message.getValue(INPUTFILENAME);
        if (inputFilename == null || project == null) {
            return this.handleError(message, "one of the mandatory param is null");
        }
        try {
            service = new StreamService(new URL(url));
        }
        catch (MalformedURLException ex) {
            return this.processException(ex, message);
        }
        Stream stream = service.getStreamPort();
        int instance = 0;
        List<String> availableProjects = stream.getProjectList();
        if (availableProjects.size() <= 0) return this.handleError(message, "No projects are available on the server.");
        if (!availableProjects.contains(project)) {
            return this.handleError(message, "project name doesn't Exist");
        }
        logger.debug((Object)("Attempting to run project \"" + project + "\" on instance " + instance));
        if (!stream.setProject(instance, project)) return this.handleError(message, "setProject failed:" + stream.getLastError(instance));
        String source = DigitalRapidsAdaptor.changeFilname(DigitalRapidsAdaptor.ExtractSourceTag(stream.loadProject(project)), inputFilename);
        boolean changeSource = stream.setSource(instance, source);
        if (!changeSource) {
            return this.handleError(message, "Unable to set input file");
        }
        if (!stream.startEncoding(instance, false)) {
            StringBuilder ErrorMsg = new StringBuilder("Start Encoding failed.");
            ErrorMsg.append(stream.getLastError(instance));
            int profiles = stream.getNumberOfProfiles(instance);
            for (int i = 0; i < profiles; ++i) {
                String profErr = stream.getProfileErrorString(instance, "/Session(" + i + ")");
                if (profErr.length() <= 0) continue;
                ErrorMsg.append("\nProfile" + i + " error's:" + profErr);
            }
            return this.handleError(message, ErrorMsg.toString());
        }
        logger.debug((Object)"Encoding Started");
        WorkflowMessage responseMessage = WorkflowMessageFactory.createAckMessage((WorkflowMessage)message);
        responseMessage.putValue(INSTANCEID, String.valueOf(instance));
        responseMessage.setSource(null);
        return this.transform(responseMessage);
    }

    private IAdaptorResponse handleError(WorkflowMessage message, String errorMsg) {
        WorkflowMessage responseMessage = WorkflowMessageFactory.createNackMessage((WorkflowMessage)message);
        responseMessage.setSource(null);
        responseMessage.putValue(ERROR_MESSAGE, errorMsg);
        return this.transform(responseMessage);
    }

    private IAdaptorResponse processException(Exception e, WorkflowMessage message) {
        WorkflowMessage responseMessage = WorkflowMessageFactory.createNackMessage((WorkflowMessage)message);
        responseMessage.putValue(STATUS, "Error");
        responseMessage.putValue(ERROR_MESSAGE, e.getMessage());
        responseMessage.setSource(null);
        return this.transform(responseMessage);
    }

    private IAdaptorResponse transform(WorkflowMessage responseMessage) {
        Marshaller m = Marshaller.newMarshaller();
        StringWriter sw = new StringWriter();
        try {
            Document responseDoc = m.marshal(responseMessage);
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.transform(new DOMSource(responseDoc.getDocumentElement()), new StreamResult(sw));
        }
        catch (MarshalException e) {
            logger.error((Object)e);
        }
        catch (TransformerException e) {
            logger.error((Object)e);
        }
        catch (TransformerFactoryConfigurationError e) {
            logger.error((Object)e);
        }
        MessageImpl iMessage = new MessageImpl((IPayload)new StringPayload(sw.getBuffer().toString()));
        return new AdaptorResponseImpl((IMessage)iMessage);
    }

    public void destroy() {
    }

    private static String changeFilname(String data, String input) {
        String filenameTag = "<FILENAME>";
        int idx = data.indexOf(filenameTag);
        int idx2 = data.indexOf("</FILENAME>");
        String res = data.substring(idx + filenameTag.length(), idx2);
        data = data.replace(res, input);
        return data;
    }

    private static String ExtractSourceTag(String xmlData) {
        int idx = xmlData.indexOf("<SOURCE ");
        int idx2 = xmlData.indexOf("</SOURCE>");
        String res = xmlData.substring(idx, idx2 + "</SOURCE>".length());
        return res;
    }
}

