/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.digitalRapids;

import ca.digitalrapids.klamathserver.Stream;
import ca.digitalrapids.klamathserver.StreamService;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.AbstractHeartBeatStrategy;
import com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.ResourceHeartBeatEvent;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;

public class DigitalRapidsHBS
extends AbstractHeartBeatStrategy
implements Runnable {
    private static final Logger logger = Logger.getLogger(DigitalRapidsHBS.class);

    protected Runnable getHeartBeatCommand() {
        return this;
    }

    @Override
    public void run() {
        Resource hbResource = this.getResource();
        String connectionString = hbResource.getHeartbeatConnectionString();
        String name = hbResource.getName();
        if (this.getContent(connectionString)) {
            logger.info((Object)"HB is Successful");
            this.fireHeartBeatSuccessEvent(this.createEvent("HB for " + name + " is Successful"));
        } else {
            this.fireHeartBeatFailureEvent(this.createEvent("DigitalRapidsHBS not available"));
        }
    }

    private ResourceHeartBeatEvent createEvent(String msg) {
        ResourceHeartBeatEvent event = new ResourceHeartBeatEvent((Object)this, this.getResource(), msg);
        return event;
    }

    private boolean getContent(String connectionString) {
        StreamService service;
        try {
            service = new StreamService(new URL(connectionString));
        }
        catch (MalformedURLException e) {
            return false;
        }
        Stream stream = service.getStreamPort();
        String version = stream.getVersion();
        if (version != null && version.length() > 0) {
            return true;
        }
        logger.error((Object)"DigitalRapid HeartBeat Strategy FAILED");
        return false;
    }
}

