/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.device.digitalRapids;

import ca.digitalrapids.klamathserver.Stream;
import ca.digitalrapids.klamathserver.StreamService;
import com.tandbergtv.workflow.resourcemanager.mgmt.initialization.AbstractInitializationStrategy;
import com.tandbergtv.workflow.resourcemanager.mgmt.initialization.ResourceInitializationEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class DigitalRapidsInitStrategy
extends AbstractInitializationStrategy
implements Runnable {
    private static final Logger logger = Logger.getLogger(DigitalRapidsInitStrategy.class);
    private int error = 0;

    protected Runnable getInitializationCommand() {
        return this;
    }

    protected long getInitializationRetryDelay() {
        return 20L;
    }

    @Override
    public void run() {
        String connectionString = this.getResource().getConnectionString();
        if (this.getContent(connectionString)) {
            this.fireInitializationSuccessEvent(this.createEvent("Init for " + this.getResource().getName() + "is Successful"));
        } else {
            ++this.error;
            if (this.error > 3) {
                this.fireInitializationFailureEvent(this.createEvent("DigitalRapids not available"));
            }
        }
    }

    private ResourceInitializationEvent createEvent(String msg) {
        ResourceInitializationEvent event = new ResourceInitializationEvent((Object)this, this.getResource(), msg);
        return event;
    }

    private boolean getContent(String connectionString) {
        int instance = 0;
        try {
            StreamService service = new StreamService(new URL(connectionString));
            Stream stream = service.getStreamPort();
            if (stream.isAppLaunched(instance)) {
                return true;
            }
            ArrayList<String> encoderArgs = new ArrayList<String>();
            encoderArgs.add("-remote");
            instance = stream.launchEncoder("device", 0, encoderArgs);
            if (instance < 0) {
                System.out.println("exiting Encoder");
                stream.exitEncoder(instance);
                return false;
            }
            System.out.println("Successfully launched encoder instance " + instance + ".");
            return true;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (Throwable tr) {
            tr.printStackTrace();
        }
        return false;
    }
}

